/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.configuration.languagefile;

import com.valorin.Main;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class LanguageFileLoader {
    private final Map<File, List<String>> lang = new HashMap<File, List<String>>();
    private final List<String> defaultLang = new ArrayList<String>();
    private List<File> customLangList;
    private final Map<String, List<String>> subDefaultLang = new HashMap<String, List<String>>();

    public LanguageFileLoader() {
        this.customLangList = this.addLanguages();
        this.loadDefaultLanguage();
        this.loadSubDefaultLanguage();
        this.copyChecker();
        this.customLangList = this.addLanguages();
        this.LanguageFileChecker();
        this.loadLang();
    }

    public void close() {
        this.lang.clear();
        this.defaultLang.clear();
        this.subDefaultLang.clear();
        this.customLangList.clear();
    }

    public List<File> getLanguagesList() {
        return this.customLangList;
    }

    public Map<File, List<String>> getLang() {
        return this.lang;
    }

    public List<String> getDefaultLang() {
        return this.defaultLang;
    }

    private void loadDefaultLanguage() {
        try {
            String s;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Main.getInstance().getResource("DefaultLanguage.txt"), StandardCharsets.UTF_8));
            while ((s = bufferedReader.readLine()) != null) {
                this.defaultLang.add(s);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<File> addLanguages() {
        ArrayList<File> fileList = new ArrayList<File>();
        File file = new File("plugins/Dantiao/Languages");
        File[] files = file.listFiles();
        if (files == null) {
            return fileList;
        }
        for (File f : files) {
            if (!f.isFile() || !f.getName().substring(f.getName().lastIndexOf(".") + 1).equals("txt")) continue;
            fileList.add(f);
        }
        return fileList;
    }

    private void loadLang() {
        this.lang.clear();
        List<File> fileList = this.customLangList;
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            ArrayList<String> messages = new ArrayList<String>();
            try {
                String s;
                FileReader fr = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fr);
                while ((s = bufferedReader.readLine()) != null) {
                    messages.add(s);
                }
                bufferedReader.close();
                fr.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lang.put(file, messages);
        }
    }

    private void copyChecker() {
        File[] fileList;
        File textFile1 = new File("plugins/Dantiao/Languages/zh_CN.txt");
        File textFile2 = new File("plugins/Dantiao/Languages/zh_TW.txt");
        File textFile3 = new File("plugins/Dantiao/Languages/en.txt");
        File fileParent = textFile1.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        for (File testFile : fileList = new File[]{textFile1, textFile2, textFile3}) {
            if (testFile.exists()) continue;
            try {
                testFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void LanguageFileChecker() {
        List<File> fileList = this.customLangList;
        for (File file : fileList) {
            int count = 0;
            try {
                FileInputStream fis = new FileInputStream(file);
                Scanner scanner = new Scanner(fis);
                while (scanner.hasNextLine()) {
                    scanner.nextLine();
                    ++count;
                }
                scanner.close();
                if (count >= this.defaultLang.size()) continue;
                this.loadSubDefaultLanguage();
                List<String> mould = this.defaultLang;
                if (file.getName().equals("zh_CN.txt") || file.getName().equals("zh_TW.txt") || file.getName().equals("en.txt")) {
                    mould = this.subDefaultLang.get(file.getName().replace(".txt", ""));
                }
                ArrayList<String> logMessageList = new ArrayList<String>();
                try {
                    String s;
                    FileReader fr = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fr);
                    while ((s = bufferedReader.readLine()) != null) {
                        logMessageList.add(s);
                    }
                    bufferedReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (int i = logMessageList.size(); i < mould.size(); ++i) {
                    logMessageList.add(mould.get(i));
                }
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    for (int i = 0; i < logMessageList.size(); ++i) {
                        if (i == logMessageList.size() - 1) {
                            writer.write((String)logMessageList.get(i));
                            continue;
                        }
                        writer.write((String)logMessageList.get(i) + "\n");
                    }
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void loadSubDefaultLanguage() {
        String[] fileLocations;
        for (String fileLocation : fileLocations = new String[]{"Languages/zh_CN.txt", "Languages/zh_TW.txt", "Languages/en.txt"}) {
            try {
                String s;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Main.getInstance().getResource(fileLocation), StandardCharsets.UTF_8));
                ArrayList<String> mList = new ArrayList<String>();
                while ((s = bufferedReader.readLine()) != null) {
                    mList.add(s);
                }
                this.subDefaultLang.put(fileLocation.replace("Languages/", "").replace(".txt", ""), mList);
                bufferedReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

