/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.configuration.languagefile;

import com.google.common.base.Charsets;
import com.valorin.Main;
import com.valorin.configuration.DataFile;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class SymbolLoader {
    private final Map<String, String> symbols = new HashMap<String, String>();
    private final List<String> symbolsMark = new ArrayList<String>();

    public SymbolLoader() {
        if (DataFile.symbolsFile.exists()) {
            if (DataFile.symbols.getKeys(false).size() == 0) {
                try {
                    YamlConfiguration defaultSymbol = new YamlConfiguration();
                    defaultSymbol.load((Reader)new BufferedReader(new InputStreamReader(Main.getInstance().getResource("symbols.yml"), Charsets.UTF_8)));
                    for (String mark : defaultSymbol.getKeys(false)) {
                        DataFile.symbols.set(mark, (Object)defaultSymbol.getString(mark));
                    }
                    DataFile.saveSymbols();
                }
                catch (Exception e) {
                    this.loadDefaultSymbols();
                }
            } else {
                this.loadSymbols();
            }
        } else {
            this.loadDefaultSymbols();
        }
    }

    public List<String> getSymbolsMark() {
        return this.symbolsMark;
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public void loadSymbols() {
        for (String symbolString : DataFile.symbols.getKeys(false)) {
            String symbol = DataFile.symbols.getString(symbolString);
            this.symbols.put(symbolString, symbol);
            this.symbolsMark.add(symbolString);
        }
    }

    private void loadDefaultSymbols() {
        YamlConfiguration defaultSymbol = new YamlConfiguration();
        try {
            defaultSymbol.load((Reader)new BufferedReader(new InputStreamReader(Main.getInstance().getResource("symbols.yml"), Charsets.UTF_8)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String symbolString : defaultSymbol.getKeys(false)) {
            String symbol = defaultSymbol.getString(symbolString);
            this.symbols.put(symbolString, symbol);
            this.symbolsMark.add(symbolString);
        }
    }
}

