/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.dan;

import com.valorin.Main;
import com.valorin.caches.DanCache;
import com.valorin.dan.CustomDan;
import com.valorin.dan.DefaultDanLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class DanHandler {
    List<CustomDan> customDans = new ArrayList<CustomDan>();
    Map<String, CustomDan> playerDans = new HashMap<String, CustomDan>();
    int threshold;

    public DanHandler() {
        this.loadCustomDanFromConfig();
    }

    public CustomDan getDanByNum(int num) {
        try {
            return this.customDans.get(num);
        }
        catch (Exception e) {
            return null;
        }
    }

    public CustomDan getDanByName(String name) {
        for (CustomDan dan : this.customDans) {
            if (!dan.getEditName().equals(name)) continue;
            return dan;
        }
        return null;
    }

    public CustomDan getPlayerDan(String playerName) {
        if (!this.playerDans.containsKey(playerName)) {
            this.refreshPlayerDan(playerName);
        }
        return this.playerDans.get(playerName);
    }

    public void refreshPlayerDan(String playerName) {
        DanCache cache = Main.getInstance().getCacheHandler().getDan();
        CustomDan playerDan = null;
        int exp = cache.get(playerName);
        if (exp >= this.threshold) {
            for (CustomDan customDan : this.customDans) {
                if (exp < customDan.getExp()) break;
                playerDan = customDan;
            }
        }
        this.playerDans.put(playerName, playerDan);
    }

    public void refreshAllPlayerDan() {
        for (String playerName : new HashSet<String>(Main.getInstance().getCacheHandler().getDan().keySet())) {
            this.refreshPlayerDan(playerName);
        }
    }

    public CustomDan getDanByExp(int exp) {
        CustomDan playerDan = null;
        if (exp >= this.threshold) {
            for (CustomDan customDan : this.customDans) {
                if (exp < customDan.getExp()) break;
                playerDan = customDan;
            }
        }
        return playerDan;
    }

    public int getNeedExpToLevelUp(String playerName) {
        int index;
        int expNow = Main.getInstance().getCacheHandler().getDan().get(playerName);
        CustomDan playerDan = this.getPlayerDan(playerName);
        int expNeed = playerDan == null ? this.threshold - expNow : ((index = this.customDans.indexOf(playerDan)) == this.customDans.size() - 1 ? 0 : this.customDans.get(index + 1).getExp() - expNow);
        return expNeed;
    }

    public List<CustomDan> getCustomDans() {
        return this.customDans;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void loadCustomDanFromConfig() {
        boolean isUseDefault = false;
        int useDefaultReason = 0;
        FileConfiguration config = Main.getInstance().getConfigManager().getConfig();
        ArrayList editNameList = new ArrayList();
        config.getConfigurationSection("Dan.CustomDan").getKeys(false).forEach(key -> {
            if (!editNameList.contains(key)) {
                editNameList.add(key);
            }
        });
        if (editNameList.size() == 0) {
            useDefaultReason = 1;
            isUseDefault = true;
        }
        ArrayList<CustomDan> customDans = new ArrayList<CustomDan>();
        ArrayList<String> customDanNameList = new ArrayList<String>();
        int expMark = 0;
        for (int n = 0; n < editNameList.size(); ++n) {
            String editName = (String)editNameList.get(n);
            String danName = config.getString("Dan.CustomDan." + editName + ".Name");
            if (customDanNameList.contains(danName)) {
                isUseDefault = true;
                useDefaultReason = 2;
                break;
            }
            customDanNameList.add(danName);
            int exp = config.getInt("Dan.CustomDan." + editName + ".Exp");
            if (exp <= expMark) {
                isUseDefault = true;
                useDefaultReason = 3;
                break;
            }
            customDans.add(new CustomDan(n, editName, danName, exp));
        }
        if (isUseDefault) {
            this.customDans = new DefaultDanLoader().get();
            this.threshold = 50;
            Bukkit.getConsoleSender().sendMessage("\u00a78[\u00a7bDantiao\u00a78]");
            Bukkit.getConsoleSender().sendMessage("\u00a7c\u81ea\u5b9a\u4e49\u6bb5\u4f4d\u52a0\u8f7d\u5931\u8d25\uff01");
            Bukkit.getConsoleSender().sendMessage("\u00a7cFailed to load the custom dans!");
            if (useDefaultReason == 1) {
                Bukkit.getConsoleSender().sendMessage("\u00a76[\u539f\u56e0(Reason)] \u00a7e\u672a\u53d1\u73b0\u4efb\u4f55\u81ea\u5b9a\u4e49\u6bb5\u4f4d\u540d\uff0c\u4f60\u53ef\u4ee5\u5c1d\u8bd5\u8f93\u5165/dt reload c\u89e3\u51b3\u8fd9\u4e2a\u95ee\u9898\uff01(Cannot find any custom dan,you can try to use /dt reload c for fixing this problem!)");
            }
            if (useDefaultReason == 2) {
                Bukkit.getConsoleSender().sendMessage("\u00a76[\u539f\u56e0(Reason)] \u00a7e\u81ea\u5b9a\u4e49\u6bb5\u4f4d\u7684\u6bb5\u4f4d\u540d\u51fa\u73b0\u4e86\u91cd\u590d\uff01(Duplicate dan names of the custom dans!)");
            }
            if (useDefaultReason == 3) {
                Bukkit.getConsoleSender().sendMessage("\u00a76[\u539f\u56e0(Reason)] \u00a7e\u81ea\u5b9a\u4e49\u6bb5\u4f4d\u8bf7\u6839\u636e\u5176\u6240\u9700\u7ecf\u9a8c\u503c\u7684\u591a\u5c11\u6765\u6392\u5e8f\u800c\u8bbe\u7f6e\uff0c\u4ece\u5c11\u5230\u591a(If you want to have custom dans,you must order them according to their exp of need when you edit dans)");
                Bukkit.getConsoleSender().sendMessage("\u00a76[\u793a\u4f8b(Example)]");
                Bukkit.getConsoleSender().sendMessage("\u00a7fDan:");
                Bukkit.getConsoleSender().sendMessage("\u00a7f  myCustomDan1:");
                Bukkit.getConsoleSender().sendMessage("\u00a7f    name: '&aPVP LEVEL I");
                Bukkit.getConsoleSender().sendMessage("\u00a7f    exp: 50");
                Bukkit.getConsoleSender().sendMessage("\u00a7f  myCustomDan2:");
                Bukkit.getConsoleSender().sendMessage("\u00a7f    name: '&6PVP LEVEL II");
                Bukkit.getConsoleSender().sendMessage("\u00a7f    exp: 200");
            }
        } else {
            this.customDans = customDans;
            this.threshold = ((CustomDan)customDans.get(0)).getExp();
        }
        if (this.customDans.size() != 0) {
            this.refreshAllPlayerDan();
        }
    }
}

