/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.data;

import com.valorin.Main;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.DataFile;
import com.valorin.data.encapsulation.Good;
import com.valorin.data.encapsulation.RankingSign;
import com.valorin.data.encapsulation.RankingSkull;
import com.valorin.data.encapsulation.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Data {
    private static boolean useDatabase;
    public static boolean areaB;
    public static boolean blacklistB;
    public static boolean danB;
    public static boolean energyB;
    public static boolean languageFileB;
    public static boolean pointB;
    public static boolean pointShopB;
    public static boolean recordB;
    public static boolean seasonB;

    public static void initialB(ConfigManager configManager) {
        if (configManager.isUseMySQL()) {
            areaB = configManager.isAreaUseMySQL();
            blacklistB = configManager.isBlacklistUseMySQL();
            danB = configManager.isDanUseMySQL();
            energyB = configManager.isEnergyUseMySQL();
            languageFileB = configManager.isLanguageFileUseMySQL();
            pointB = configManager.isPointUseMySQL();
            pointShopB = configManager.isPointShopUseMySQL();
            recordB = configManager.isRecordUseMySQL();
            seasonB = configManager.isSeasonUseMySQL();
        }
    }

    public static List<String> getArenas() {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenas();
        }
        ArrayList<String> arenaList = new ArrayList<String>();
        if (!DataFile.areasFile.exists()) {
            return arenaList;
        }
        ConfigurationSection section = DataFile.areas.getConfigurationSection("Arenas");
        if (section == null) {
            return arenaList;
        }
        arenaList.addAll(section.getKeys(false));
        return arenaList;
    }

    public static String getArenaDisplayName(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenaDisplayName(editName);
        }
        return DataFile.areas.getString("Arenas." + editName + ".Name");
    }

    public static Location getArenaPointA(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenaPointA(editName);
        }
        World world = Bukkit.getWorld((String)DataFile.areas.getString("Arenas." + editName + ".A.World"));
        double x = DataFile.areas.getDouble("Arenas." + editName + ".A.X");
        double y = DataFile.areas.getDouble("Arenas." + editName + ".A.Y");
        double z = DataFile.areas.getDouble("Arenas." + editName + ".A.Z");
        float yaw = (float)DataFile.areas.getDouble("Arenas." + editName + ".A.YAW");
        float pitch = (float)DataFile.areas.getDouble("Arenas." + editName + ".A.PITCH");
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static Location getArenaPointB(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenaPointB(editName);
        }
        World world = Bukkit.getWorld((String)DataFile.areas.getString("Arenas." + editName + ".B.World"));
        double x = DataFile.areas.getDouble("Arenas." + editName + ".B.X");
        double y = DataFile.areas.getDouble("Arenas." + editName + ".B.Y");
        double z = DataFile.areas.getDouble("Arenas." + editName + ".B.Z");
        float yaw = (float)DataFile.areas.getDouble("Arenas." + editName + ".B.YAW");
        float pitch = (float)DataFile.areas.getDouble("Arenas." + editName + ".B.PITCH");
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static List<String> getArenaCommands(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenaCommands(editName);
        }
        return DataFile.areas.getStringList("Arenas." + editName + ".Commands");
    }

    public static Location getArenaWatchingPoint(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenaWatchingPoint(editName);
        }
        String world = DataFile.areas.getString("Arenas." + editName + ".WatchingPoint.World");
        if (world == null) {
            return null;
        }
        double x = DataFile.areas.getDouble("Arenas." + editName + ".WatchingPoint.X");
        double y = DataFile.areas.getDouble("Arenas." + editName + ".WatchingPoint.Y");
        double z = DataFile.areas.getDouble("Arenas." + editName + ".WatchingPoint.Z");
        float yaw = (float)DataFile.areas.getDouble("Arenas." + editName + ".WatchingPoint.YAW");
        float pitch = (float)DataFile.areas.getDouble("Arenas." + editName + ".WatchingPoint.PITCH");
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    public static void setArenaCommands(final String editName, final List<String> list) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setArenaCommands(editName, list);
                } else {
                    DataFile.areas.set("Arenas." + editName + ".Commands", (Object)list);
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setArenaWatchingPoint(final String editName, final Location location) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setArenaWatchingPoint(editName, location);
                } else {
                    if (location == null) {
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint", null);
                    } else {
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint.World", (Object)location.getWorld().getName());
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint.X", (Object)location.getX());
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint.Y", (Object)location.getY());
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint.Z", (Object)location.getZ());
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint.YAW", (Object)Float.valueOf(location.getYaw()));
                        DataFile.areas.set("Arenas." + editName + ".WatchingPoint.PITCH", (Object)Float.valueOf(location.getPitch()));
                    }
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void saveArena(final String editName, final String displayName, final Location pointA, final Location pointB) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().saveArena(editName, displayName, pointA, pointB);
                } else {
                    DataFile.areas.set("Arenas." + editName + ".A.World", (Object)pointA.getWorld().getName());
                    DataFile.areas.set("Arenas." + editName + ".A.X", (Object)pointA.getX());
                    DataFile.areas.set("Arenas." + editName + ".A.Y", (Object)pointA.getY());
                    DataFile.areas.set("Arenas." + editName + ".A.Z", (Object)pointA.getZ());
                    DataFile.areas.set("Arenas." + editName + ".A.YAW", (Object)Float.valueOf(pointA.getYaw()));
                    DataFile.areas.set("Arenas." + editName + ".A.PITCH", (Object)Float.valueOf(pointA.getPitch()));
                    DataFile.areas.set("Arenas." + editName + ".B.World", (Object)pointB.getWorld().getName());
                    DataFile.areas.set("Arenas." + editName + ".B.X", (Object)pointB.getX());
                    DataFile.areas.set("Arenas." + editName + ".B.Y", (Object)pointB.getY());
                    DataFile.areas.set("Arenas." + editName + ".B.Z", (Object)pointB.getZ());
                    DataFile.areas.set("Arenas." + editName + ".B.YAW", (Object)Float.valueOf(pointB.getYaw()));
                    DataFile.areas.set("Arenas." + editName + ".B.PITCH", (Object)Float.valueOf(pointB.getPitch()));
                    DataFile.areas.set("Arenas." + editName + ".Name", (Object)displayName);
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void deleteArena(final String editName) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().deleteArena(editName);
                } else {
                    DataFile.areas.set("Arenas." + editName, null);
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static Location getHologramLocation(int type) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getHologramLocation(type);
        }
        String prefix = type == 0 ? "Dantiao-HD-Win." : "Dantiao-HD-KD.";
        String world = DataFile.areas.getString(prefix + "World");
        if (world == null) {
            return null;
        }
        double x = DataFile.areas.getInt(prefix + "X");
        double y = DataFile.areas.getInt(prefix + "Y");
        double z = DataFile.areas.getInt(prefix + "Z");
        return new Location(Bukkit.getWorld((String)world), x, y, z);
    }

    public static void setHologramLocation(int type, Location location) {
        useDatabase = areaB;
        if (useDatabase) {
            Main.getInstance().getMySQL().setHologramLocation(type, location);
        } else {
            String prefix = type == 0 ? "Dantiao-HD-Win." : "Dantiao-HD-KD.";
            if (location == null) {
                DataFile.areas.set(prefix.replace(".", ""), null);
            } else {
                DataFile.areas.set(prefix + "World", (Object)location.getWorld().getName());
                DataFile.areas.set(prefix + "X", (Object)location.getX());
                DataFile.areas.set(prefix + "Y", (Object)location.getY());
                DataFile.areas.set(prefix + "Z", (Object)location.getZ());
            }
            DataFile.saveAreas();
        }
    }

    public static Location getLobbyLocation() {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getLobbyLocation();
        }
        String prefix = "Dantiao-LobbyPoint.";
        String world = DataFile.areas.getString(prefix + "World");
        if (world == null) {
            return null;
        }
        double x = DataFile.areas.getInt(prefix + "X");
        double y = DataFile.areas.getInt(prefix + "Y");
        double z = DataFile.areas.getInt(prefix + "Z");
        return new Location(Bukkit.getWorld((String)world), x, y, z);
    }

    public static void setLobbyLocation(Location location) {
        useDatabase = areaB;
        if (useDatabase) {
            Main.getInstance().getMySQL().setLobbyLocation(location);
        } else {
            if (location == null) {
                DataFile.areas.set("Dantiao-LobbyPoint", null);
            } else {
                String prefix = "Dantiao-LobbyPoint.";
                DataFile.areas.set(prefix + "World", (Object)location.getWorld().getName());
                DataFile.areas.set(prefix + "X", (Object)location.getX());
                DataFile.areas.set(prefix + "Y", (Object)location.getY());
                DataFile.areas.set(prefix + "Z", (Object)location.getZ());
            }
            DataFile.saveAreas();
        }
    }

    public static List<RankingSkull> getRankingSkullList() {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getRankingSkull();
        }
        ArrayList<RankingSkull> rankingSkullList = new ArrayList<RankingSkull>();
        if (!DataFile.areasFile.exists()) {
            return rankingSkullList;
        }
        ConfigurationSection section = DataFile.areas.getConfigurationSection("RankingSkulls");
        if (section == null) {
            return rankingSkullList;
        }
        for (String key : section.getKeys(false)) {
            String prefix = "RankingSkulls." + key + ".";
            String worldName = DataFile.areas.getString(prefix + "World");
            World world = Bukkit.getWorld((String)worldName);
            double x = DataFile.areas.getInt(prefix + "X");
            double y = DataFile.areas.getInt(prefix + "Y");
            double z = DataFile.areas.getInt(prefix + "Z");
            Location location = null;
            if (world != null) {
                location = new Location(world, x, y, z);
            }
            String editName = DataFile.areas.getString(prefix + "EditName");
            String rankingType = DataFile.areas.getString(prefix + "RankingType");
            int ranking = DataFile.areas.getInt(prefix + "Ranking");
            RankingSkull rankingSkull = new RankingSkull(editName, rankingType, ranking, location);
            rankingSkullList.add(rankingSkull);
        }
        return rankingSkullList;
    }

    public static void addRankingSkull(final String editName, final String rankingType, final int ranking, final Location location) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().addRankingSkull(editName, rankingType, ranking, location);
                } else {
                    String prefix = "RankingSkulls." + editName + ".";
                    DataFile.areas.set(prefix + "EditName", (Object)editName);
                    DataFile.areas.set(prefix + "Ranking", (Object)ranking);
                    DataFile.areas.set(prefix + "RankingType", (Object)rankingType);
                    DataFile.areas.set(prefix + "World", (Object)location.getWorld().getName());
                    DataFile.areas.set(prefix + "X", (Object)location.getX());
                    DataFile.areas.set(prefix + "Y", (Object)location.getY());
                    DataFile.areas.set(prefix + "Z", (Object)location.getZ());
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void removeRankingSkull(final String editName) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().removeRankingSkull(editName);
                } else {
                    DataFile.areas.set("RankingSkulls." + editName, null);
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static List<RankingSign> getRankingSignList() {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getRankingSign();
        }
        ArrayList<RankingSign> rankingSignList = new ArrayList<RankingSign>();
        if (!DataFile.areasFile.exists()) {
            return rankingSignList;
        }
        ConfigurationSection section = DataFile.areas.getConfigurationSection("RankingSigns");
        if (section == null) {
            return rankingSignList;
        }
        for (String key : section.getKeys(false)) {
            String prefix = "RankingSigns." + key + ".";
            String worldName = DataFile.areas.getString(prefix + "World");
            World world = Bukkit.getWorld((String)worldName);
            double x = DataFile.areas.getInt(prefix + "X");
            double y = DataFile.areas.getInt(prefix + "Y");
            double z = DataFile.areas.getInt(prefix + "Z");
            Location location = null;
            if (world != null) {
                location = new Location(world, x, y, z);
            }
            String editName = DataFile.areas.getString(prefix + "EditName");
            String rankingType = DataFile.areas.getString(prefix + "RankingType");
            int ranking = DataFile.areas.getInt(prefix + "Ranking");
            List text = DataFile.areas.getStringList(prefix + "Text");
            RankingSign rankingSign = new RankingSign(editName, rankingType, ranking, location, text);
            rankingSignList.add(rankingSign);
        }
        return rankingSignList;
    }

    public static void addRankingSign(final String editName, final String rankingType, final int ranking, final Location location, final List<String> text) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().addRankingSign(editName, rankingType, ranking, location, text);
                } else {
                    String prefix = "RankingSigns." + editName + ".";
                    DataFile.areas.set(prefix + "EditName", (Object)editName);
                    DataFile.areas.set(prefix + "Ranking", (Object)ranking);
                    DataFile.areas.set(prefix + "RankingType", (Object)rankingType);
                    DataFile.areas.set(prefix + "World", (Object)location.getWorld().getName());
                    DataFile.areas.set(prefix + "X", (Object)location.getX());
                    DataFile.areas.set(prefix + "Y", (Object)location.getY());
                    DataFile.areas.set(prefix + "Z", (Object)location.getZ());
                    DataFile.areas.set(prefix + "Text", (Object)text);
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void removeRankingSign(final String editName) {
        useDatabase = areaB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().removeRankingSign(editName);
                } else {
                    DataFile.areas.set("RankingSigns." + editName, null);
                    DataFile.saveAreas();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static List<String> getBlacklist() {
        useDatabase = blacklistB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getBlacklist();
        }
        return DataFile.blacklist.getStringList("BlackList");
    }

    public static void setBlacklist(List<String> list) {
        useDatabase = blacklistB;
        if (useDatabase) {
            Main.getInstance().getMySQL().setBlacklist(list);
        } else {
            DataFile.blacklist.set("BlackList", list);
            DataFile.saveBlackList();
        }
    }

    public static int getDanExp(String name) {
        useDatabase = danB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getDanExp(name);
        }
        return DataFile.playerData.getInt(name + ".Exp");
    }

    public static void setDanExp(String name, int exp, boolean isAsyn) {
        useDatabase = danB;
        final Action action = () -> {
            if (useDatabase) {
                Main.getInstance().getMySQL().setDanExp(name, exp);
            } else {
                DataFile.playerData.set(name + ".Exp", (Object)exp);
                DataFile.savePlayerData();
            }
        };
        if (isAsyn) {
            new BukkitRunnable(){

                public void run() {
                    action.run();
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            action.run();
        }
    }

    public static String getLanguageFile(String name) {
        useDatabase = languageFileB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getLanguageFile(name);
        }
        return DataFile.playerData.getString(name + ".Language");
    }

    public static void setLanguageFile(String name, String language, boolean isAsyn) {
        useDatabase = languageFileB;
        final Action action = () -> {
            if (useDatabase) {
                Main.getInstance().getMySQL().setLanguageFile(name, language);
            } else {
                DataFile.playerData.set(name + ".Language", (Object)language);
                DataFile.savePlayerData();
            }
        };
        if (isAsyn) {
            new BukkitRunnable(){

                public void run() {
                    action.run();
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            action.run();
        }
    }

    public static double getPoint(String name) {
        useDatabase = pointB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getPoint(name);
        }
        return DataFile.playerData.getDouble(name + ".Points");
    }

    public static void setPoint(String name, double point, boolean isAsyn) {
        useDatabase = pointB;
        final Action action = () -> {
            if (useDatabase) {
                Main.getInstance().getMySQL().setPoint(name, point);
            } else {
                DataFile.playerData.set(name + ".Points", (Object)point);
                DataFile.savePlayerData();
            }
        };
        if (isAsyn) {
            new BukkitRunnable(){

                public void run() {
                    action.run();
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            action.run();
        }
    }

    public static int getHistoryGood() {
        useDatabase = pointShopB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getHistoryGood();
        }
        return DataFile.shop.getInt("Num");
    }

    public static List<Good> getGoodList() {
        useDatabase = pointShopB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getGoodList();
        }
        ArrayList<Good> list = new ArrayList<Good>();
        Set set = DataFile.shop.getKeys(false);
        set.remove("Num");
        for (String key : set) {
            ItemStack item = DataFile.shop.getItemStack(key + ".Item");
            double price = DataFile.shop.getDouble(key + ".Price");
            String broadcast = DataFile.shop.getString(key + ".Broadcast");
            String description = DataFile.shop.getString(key + ".Description");
            int salesVolume = DataFile.shop.getInt(key + ".SalesVolume");
            String dan = DataFile.shop.getString(key + ".Dan");
            List commands = DataFile.shop.getStringList(key + ".Commands");
            int num = Integer.parseInt(key.replace("n", ""));
            Good good = new Good(num, item, price, broadcast, description, salesVolume, dan, commands);
            list.add(good);
        }
        return list;
    }

    public static void setBroadcastForGood(final int num, final String broadcast) {
        useDatabase = pointShopB;
        if (useDatabase) {
            new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = "setBroadcastForGood";
                    synchronized ("setBroadcastForGood") {
                        Main.getInstance().getMySQL().setBroadcastForGood(num, broadcast);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            DataFile.shop.set("n" + num + ".Broadcast", (Object)broadcast);
            DataFile.saveShop();
        }
    }

    public static void setDescriptionForGood(final int num, final String description) {
        useDatabase = pointShopB;
        if (useDatabase) {
            new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = "setDescriptionForGood";
                    synchronized ("setDescriptionForGood") {
                        Main.getInstance().getMySQL().setDescriptionForGood(num, description);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            DataFile.shop.set("n" + num + ".Description", (Object)description);
            DataFile.saveShop();
        }
    }

    public static void updateSalesVolume(final int num) {
        useDatabase = pointShopB;
        if (useDatabase) {
            new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = "updateSalesVolume";
                    synchronized ("updateSalesVolume") {
                        Main.getInstance().getMySQL().updateSalesVolume(num);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            int now = DataFile.shop.getInt("n" + num + ".SalesVolume");
            DataFile.shop.set("n" + num + ".SalesVolume", (Object)(now + 1));
            DataFile.saveShop();
        }
    }

    public static void updateHistoryGood() {
        useDatabase = pointShopB;
        if (useDatabase) {
            new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = "updateHistoryGood";
                    synchronized ("updateHistoryGood") {
                        Main.getInstance().getMySQL().updateHistoryGood();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            DataFile.shop.set("Num", (Object)(DataFile.shop.getInt("Num") + 1));
            DataFile.saveShop();
        }
    }

    public static void addGood(final int num, final ItemStack item, final double price) {
        useDatabase = pointShopB;
        if (useDatabase) {
            new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = "addGood";
                    synchronized ("addGood") {
                        Main.getInstance().getMySQL().addGood(num, item, price);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            DataFile.shop.set("n" + num + ".Item", (Object)item);
            DataFile.shop.set("n" + num + ".Price", (Object)price);
            DataFile.saveShop();
        }
    }

    public static void removeGood(final int num) {
        useDatabase = pointShopB;
        if (useDatabase) {
            new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = "removeGood";
                    synchronized ("removeGood") {
                        Main.getInstance().getMySQL().removeGood(num);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            DataFile.shop.set("n" + num, null);
            DataFile.saveShop();
        }
    }

    public static List<String> getWinRanking() {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getRanking(0);
        }
        return DataFile.ranking.getStringList("Win");
    }

    public static List<String> getKDRanking() {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getRanking(1);
        }
        return DataFile.ranking.getStringList("KD");
    }

    public static void setRanking(final int type, final List<String> list) {
        useDatabase = recordB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setRanking";
                synchronized ("setRanking") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setRanking(type, list);
                    } else {
                        if (type == 0) {
                            DataFile.ranking.set("Win", (Object)list);
                        } else {
                            DataFile.ranking.set("KD", (Object)list);
                        }
                        DataFile.saveRanking();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static int getWins(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getWins(name);
        }
        return DataFile.records.getInt(name + ".Win");
    }

    public static int getLoses(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getLoses(name);
        }
        return DataFile.records.getInt(name + ".Lose");
    }

    public static int getDraws(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getDraws(name);
        }
        return DataFile.records.getInt(name + ".Draw");
    }

    public static int getWinningStreakTimes(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getWinningStreakTimes(name);
        }
        return DataFile.playerData.getInt(name + ".Winning-Streak-Times");
    }

    public static int getMaxWinningStreakTimes(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getMaxWinningStreakTimes(name);
        }
        return DataFile.playerData.getInt(name + ".Max-Winning-Streak-Times");
    }

    public static void setWins(final String name, final int value) {
        useDatabase = recordB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setWins";
                synchronized ("setWins") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setWins(name, value);
                    } else {
                        DataFile.records.set(name + ".Win", (Object)value);
                        DataFile.saveRecords();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setLoses(final String name, final int value) {
        useDatabase = recordB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setLoses";
                synchronized ("setLoses") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setLoses(name, value);
                    } else {
                        DataFile.records.set(name + ".Lose", (Object)value);
                        DataFile.saveRecords();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setDraws(final String name, final int value) {
        useDatabase = recordB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setDraws";
                synchronized ("setDraws") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setDraws(name, value);
                    } else {
                        DataFile.records.set(name + ".Draw", (Object)value);
                        DataFile.saveRecords();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setWinningStreakTimes(final String name, final int value) {
        useDatabase = recordB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setWinningStreakTimes";
                synchronized ("setWinningStreakTimes") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setWinningStreakTimes(name, value);
                    } else {
                        DataFile.records.set(name + ".Winning-Streak-Times", (Object)value);
                        DataFile.saveRecords();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setMaxWinningStreakTimes(final String name, final int value) {
        useDatabase = recordB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setMaxWinningStreakTimes";
                synchronized ("setMaxWinningStreakTimes") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setMaxWinningStreakTimes(name, value);
                    } else {
                        DataFile.records.set(name + ".Max-Winning-Streak-Times", (Object)value);
                        DataFile.saveRecords();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecord(String name, String date, String opponent, String server, int time, double damage, double maxDamage, int result, int startWay, int expChange, String arenaEditName) {
        useDatabase = recordB;
        String string = "addRecord";
        synchronized ("addRecord") {
            if (useDatabase) {
                Main.getInstance().getMySQL().addRecord(name, date, opponent, server, time, damage, maxDamage, result, startWay, expChange, arenaEditName);
            } else {
                int logWins = DataFile.records.getInt(name + ".Win");
                int logLoses = DataFile.records.getInt(name + ".Lose");
                int logDraws = DataFile.records.getInt(name + ".Draw");
                int logGameTimes = logWins + logLoses + logDraws;
                DataFile.records.set(name + ".Record." + logGameTimes + ".player", (Object)opponent);
                DataFile.records.set(name + ".Record." + logGameTimes + ".time", (Object)time);
                DataFile.records.set(name + ".Record." + logGameTimes + ".date", (Object)date);
                DataFile.records.set(name + ".Record." + logGameTimes + ".damage", (Object)damage);
                DataFile.records.set(name + ".Record." + logGameTimes + ".maxdamage", (Object)maxDamage);
                if (result == 0) {
                    DataFile.records.set(name + ".Record." + logGameTimes + ".isWin", (Object)true);
                    DataFile.records.set(name + ".Record." + logGameTimes + ".isDraw", (Object)false);
                }
                if (result == 1) {
                    DataFile.records.set(name + ".Record." + logGameTimes + ".isWin", (Object)false);
                    DataFile.records.set(name + ".Record." + logGameTimes + ".isDraw", (Object)false);
                }
                if (result == 2) {
                    DataFile.records.set(name + ".Record." + logGameTimes + ".isWin", (Object)false);
                    DataFile.records.set(name + ".Record." + logGameTimes + ".isDraw", (Object)true);
                }
                DataFile.records.set(name + ".Record." + logGameTimes + ".startWay", (Object)startWay);
                DataFile.records.set(name + ".Record." + logGameTimes + ".expChange", (Object)expChange);
                DataFile.records.set(name + ".Record." + logGameTimes + ".arenaEditName", (Object)arenaEditName);
                DataFile.records.set(name + ".Record." + logGameTimes + ".server", (Object)server);
                DataFile.saveRecords();
            }
            // ** MonitorExit[var13_11] (shouldn't be in output)
            return;
        }
    }

    public static void initialRecordData(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Main.getInstance().getMySQL().initialRecordData(name));
        }
    }

    public static int getRecordNumber(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getRecordNumber(name);
        }
        int wins = DataFile.records.getInt(name + ".Win");
        int loses = DataFile.records.getInt(name + ".Lose");
        int draws = DataFile.records.getInt(name + ".Draw");
        return wins + loses + draws;
    }

    public static List<Record> getRecordList(String name) {
        useDatabase = recordB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getRecordList(name);
        }
        ArrayList<Record> recordList = new ArrayList<Record>();
        ConfigurationSection section = DataFile.records.getConfigurationSection(name + ".Record");
        if (section != null) {
            section.getKeys(false).forEach(subKey -> {
                String prefix = name + ".Record." + subKey;
                String date = DataFile.records.getString(prefix + ".date");
                String opponent = DataFile.records.getString(prefix + ".player");
                String server = DataFile.records.getString(prefix + ".server");
                int time = DataFile.records.getInt(prefix + ".time");
                int damage = DataFile.records.getInt(prefix + ".damage");
                int maxDamage = DataFile.records.getInt(prefix + ".maxdamage");
                int result = DataFile.records.getBoolean(prefix + ".isWin") ? 0 : (DataFile.records.getBoolean(prefix + ".isDraw") ? 2 : 1);
                int startWay = DataFile.records.getInt(prefix + ".startWay");
                int expChange = DataFile.records.getInt(prefix + ".expChange");
                String arenaEditName = DataFile.records.getString(prefix + ".arenaEditName");
                Record record = new Record(name, date, opponent, server, time, damage, maxDamage, result, startWay, expChange, arenaEditName);
                recordList.add(record);
            });
        }
        return recordList;
    }

    public static double getEnergy(String name) {
        useDatabase = energyB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getEnergy(name);
        }
        return DataFile.playerData.getDouble(name + ".Energy");
    }

    public static void setEnergy(String name, double energy, boolean isAsyn) {
        useDatabase = energyB;
        final Action action = () -> {
            String string = "setEnergy";
            synchronized ("setEnergy") {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setEnergy(name, energy);
                } else {
                    DataFile.playerData.set(name + ".Energy", (Object)energy);
                    DataFile.savePlayerData();
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        };
        if (isAsyn) {
            new BukkitRunnable(){

                public void run() {
                    action.run();
                }
            }.runTaskAsynchronously((Plugin)Main.getInstance());
        } else {
            action.run();
        }
    }

    public static String getSeasonDanMessage(String danEditName) {
        useDatabase = seasonB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getSeasonDanMessage(danEditName);
        }
        return DataFile.season.getString(danEditName + ".message");
    }

    public static void setSeasonDanMessage(final String danEditName, final String message) {
        useDatabase = seasonB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setSeasonDanMessage(danEditName, message);
                } else {
                    DataFile.season.set(danEditName + ".message", (Object)message);
                    DataFile.saveSeason();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static List<ItemStack> getSeasonDanItemStacks(String danEditName) {
        useDatabase = seasonB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getSeasonDanItemStacks(danEditName);
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ConfigurationSection section = DataFile.season.getConfigurationSection(danEditName + ".ItemStacks");
        if (section != null) {
            section.getKeys(false).forEach(subKey -> {
                ItemStack itemStack = DataFile.season.getItemStack(danEditName + ".ItemStacks." + subKey);
                itemStacks.add(itemStack);
            });
        }
        return itemStacks;
    }

    public static void setSeasonDanItemStacks(final String danEditName, final List<ItemStack> itemStacks) {
        useDatabase = seasonB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setSeasonDanItemStacks(danEditName, itemStacks);
                } else {
                    DataFile.season.set(danEditName + ".ItemStacks", null);
                    for (int i = 0; i < itemStacks.size(); ++i) {
                        ItemStack itemStack = (ItemStack)itemStacks.get(i);
                        DataFile.season.set(danEditName + ".ItemStacks." + i, (Object)itemStack);
                    }
                    DataFile.saveSeason();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static int getSeasonDanPoints(String danEditName) {
        useDatabase = seasonB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getSeasonDanPoints(danEditName);
        }
        return DataFile.season.getInt(danEditName + ".Points");
    }

    public static void setSeasonDanPoints(final String danEditName, final int points) {
        useDatabase = seasonB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setSeasonDanPoints(danEditName, points);
                } else {
                    DataFile.season.set(danEditName + ".Points", (Object)points);
                    DataFile.saveSeason();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static boolean isSeasonDanEnable(String danEditName) {
        useDatabase = seasonB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().isSeasonDanEnable(danEditName);
        }
        return DataFile.season.getBoolean(danEditName + ".Enable");
    }

    public static void setSeasonDanEnable(final String danEditName, final boolean enable) {
        useDatabase = seasonB;
        new BukkitRunnable(){

            public void run() {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setSeasonDanEnable(danEditName, enable);
                } else {
                    DataFile.season.set(danEditName + ".Enable", (Object)enable);
                    DataFile.saveSeason();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setDanForGood(final int num, final String dan) {
        useDatabase = pointShopB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setDanForGood";
                synchronized ("setDanForGood") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setDanForGood(num, dan);
                    } else {
                        DataFile.shop.set("n" + num + ".Dan", (Object)dan);
                        DataFile.saveShop();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setCommandsForGood(final int num, final List<String> commands) {
        useDatabase = pointShopB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setCommandsForGood";
                synchronized ("setCommandsForGood") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setCommandsForGood(num, commands);
                    } else {
                        DataFile.shop.set("n" + num + ".Commands", (Object)commands);
                        DataFile.saveShop();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static void setArenaKit(final String editName, final List<ItemStack> itemStacks) {
        useDatabase = areaB;
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = "setArenaKit";
                synchronized ("setArenaKit") {
                    if (useDatabase) {
                        Main.getInstance().getMySQL().setArenaKit(editName, itemStacks);
                    } else {
                        DataFile.areas.set("Arenas." + editName + ".KitItem", null);
                        for (int i = 0; i < itemStacks.size(); ++i) {
                            DataFile.areas.set("Arenas." + editName + ".KitItem." + i, itemStacks.get(i));
                        }
                        DataFile.saveAreas();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public static List<ItemStack> getArenaKit(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().getArenaKit(editName);
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ConfigurationSection section = DataFile.areas.getConfigurationSection("Arenas." + editName + ".KitItem");
        if (section == null) {
            return itemStacks;
        }
        section.getKeys(false).forEach(key -> itemStacks.add(DataFile.areas.getItemStack("Arenas." + editName + ".KitItem." + key)));
        return itemStacks;
    }

    public static boolean isArenaKitEnable(String editName) {
        useDatabase = areaB;
        if (useDatabase) {
            return Main.getInstance().getMySQL().isArenaKitEnable(editName);
        }
        return DataFile.areas.getBoolean("Arenas." + editName + ".KitEnable");
    }

    public static void setArenaKitEnable(String editName, boolean enable) {
        useDatabase = areaB;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            String string = "setArenaKitEnable";
            synchronized ("setArenaKitEnable") {
                if (useDatabase) {
                    Main.getInstance().getMySQL().setArenaKitEnable(editName, enable);
                } else {
                    DataFile.areas.set("Arenas." + editName + ".KitEnable", (Object)enable);
                    DataFile.saveAreas();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        });
    }

    static {
        areaB = false;
        blacklistB = false;
        danB = false;
        energyB = false;
        languageFileB = false;
        pointB = false;
        pointShopB = false;
        recordB = false;
        seasonB = false;
    }

    public static interface Action {
        public void run();
    }
}

