/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.event.game;

import com.valorin.Main;
import com.valorin.arenas.Arena;
import com.valorin.arenas.ArenaManager;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.util.TeleportUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EventTeleport
implements Listener {
    @EventHandler
    public void onTpToGamer(PlayerTeleportEvent e) {
        Player player = e.getPlayer();
        String playerName = player.getName();
        ArenaManager arenaManager = Main.getInstance().getArenaManager();
        if (playerName == null) {
            return;
        }
        if (player.isOp()) {
            return;
        }
        Location to = e.getTo();
        for (String arenaEditName : ArenaManager.busyArenasName) {
            Arena arena = arenaManager.getArena(arenaEditName);
            if (arena.getp1() == null || arena.getp2() == null) continue;
            if (player.getName().equals(arena.getp1()) || player.getName().equals(arena.getp2())) {
                return;
            }
            Location player1Location = Bukkit.getPlayerExact((String)arena.getp1()).getLocation();
            Location player2Location = Bukkit.getPlayerExact((String)arena.getp2()).getLocation();
            String targetPlayerName = null;
            if (Math.abs(player1Location.getBlockX() - to.getBlockX()) <= 2 && Math.abs(player1Location.getBlockY() - to.getBlockY()) <= 2 && Math.abs(player1Location.getBlockZ() - to.getBlockZ()) <= 2) {
                targetPlayerName = Bukkit.getPlayerExact((String)arena.getp1()).getName();
            }
            if (Math.abs(player2Location.getBlockX() - to.getBlockX()) <= 2 && Math.abs(player2Location.getBlockY() - to.getBlockY()) <= 2 && Math.abs(player2Location.getBlockZ() - to.getBlockZ()) <= 2) {
                targetPlayerName = Bukkit.getPlayerExact((String)arena.getp2()).getName();
            }
            if (targetPlayerName == null) continue;
            e.setCancelled(true);
            MessageSender.sm("&c[x]\u73a9\u5bb6{player}\u6b63\u5728\u5355\u6311\u7ade\u6280\u573a\u6bd4\u8d5b\u4e2d\uff0c\u73b0\u5728\u4e0d\u80fd\u4f20\u9001\u5230TA\u8eab\u65c1", player, "player", new String[]{targetPlayerName});
        }
    }

    @EventHandler
    public void onGamerTpViaOtherPlugin(PlayerTeleportEvent e) {
        Player player = e.getPlayer();
        String playerName = player.getName();
        ArenaManager arenaManager = Main.getInstance().getArenaManager();
        if (playerName == null) {
            return;
        }
        if (arenaManager.isPlayerBusy(playerName) && e.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.PLUGIN) && !TeleportUtil.legalTeleportPlayer.contains(playerName) && !Main.getInstance().getConfigManager().isTeleportationTriggeredByOtherPluginAllowed()) {
            MessageSender.sm("&c[x]\u53d1\u751f\u975e\u6cd5\u4f20\u9001\uff0c\u5df2\u5236\u6b62", player);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void useEnderPearl(PlayerTeleportEvent e) {
        Arena arena;
        Player player = e.getPlayer();
        String playerName = player.getName();
        ArenaManager ah = Main.getInstance().getArenaManager();
        if (ah.isPlayerBusy(playerName) && (arena = ah.getArena(ah.getPlayerOfArena(playerName))).getStage() == 0 && e.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.ENDER_PEARL)) {
            e.setCancelled(true);
            MessageSender.sm("&c[x]\u8fd8\u672a\u6b63\u5f0f\u5f00\u8d5b\uff0c\u8bf7\u4e0d\u8981\u4f7f\u7528\u672b\u5f71\u73cd\u73e0\uff01", player);
        }
    }
}

