/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.itemstack;

import com.valorin.Main;
import com.valorin.caches.ArenaInfoCache;
import com.valorin.caches.PointCache;
import com.valorin.caches.RecordCache;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.dan.CustomDan;
import com.valorin.dan.DanHandler;
import com.valorin.data.encapsulation.ArenaInfo;
import com.valorin.data.encapsulation.Good;
import com.valorin.data.encapsulation.Record;
import com.valorin.queue.Matching;
import com.valorin.specialtext.Dec;
import com.valorin.util.ItemCreator;
import com.valorin.util.ViaVersion;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIItems {
    public static ItemStack getPage(String playerName, int page, int maxPage) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        return new ItemCreator(ViaVersion.getMapMaterial(), 1, 0, MessageSender.gm("&f\u5f53\u524d\u9875\u7801\uff1a{page}/{maxpage}", player, "page maxpage", new String[]{"" + page, "" + maxPage}), MessageSender.gml(" |&9<\u5de6\u952e\u4e0b\u4e00\u9875/\u53f3\u952e\u4e0a\u4e00\u9875>|&r", player), null, Enchantment.LUCK, true).get();
    }

    public static ItemStack getStart(String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        String displayName = MessageSender.gm("&f<[ \u5168\u670d\u5339\u914d &f]>", player);
        ArrayList<String> lore = new ArrayList<String>((Collection)Objects.requireNonNull(MessageSender.gml(" |&e\u5728\u7ebf\u5bfb\u627e\u5bf9\u624b|&f&l>> &a\u70b9\u51fb\u5f00\u59cb", player)));
        lore.add("");
        lore.add(MessageSender.gm("&b\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ade\u6280\u573a(\u53f3\u952e\u5207\u6362):", player));
        List<ArenaInfo> arenaInfoList = Main.getInstance().getCacheHandler().getArenaInfo().getArenaInfoList();
        if (arenaInfoList.isEmpty()) {
            lore.add(MessageSender.gm("&7\u6ca1\u6709\u53ef\u4f9b\u9009\u62e9\u7684\u7ade\u6280\u573a", player));
        } else {
            lore.add("\u00a7f\u27a3 " + MessageSender.gm("\u968f\u673a", player));
            List<Matching> matchingList = Main.getInstance().getMatchingHandler().getMatchingList();
            for (Matching matching : matchingList) {
                lore.add("\u00a77" + matching.getArenaDisplayName());
            }
        }
        lore.add("");
        return new ItemCreator(ViaVersion.getGoldenAxeMaterial(), 1, 0, displayName, lore, null, null, true).get();
    }

    public static ItemStack updateStart(String playerName, int second, String arenaEditName, String arenaDisplayName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        String displayName = MessageSender.gm("&f<[ &7\u5168\u670d\u5339\u914d &f]>", player);
        ArrayList<String> lore = new ArrayList<String>((Collection)Objects.requireNonNull(MessageSender.gml(" |&7\u5728\u7ebf\u5bfb\u627e\u5bf9\u624b|&f&l>> &6\u641c\u5bfb\u4e2d..{second}s", player, "second", new String[]{second + ""})));
        if (arenaEditName == null) {
            lore.add(MessageSender.gm("&7[&3*&7] &f\u968f\u673a\u7ade\u6280\u573a", player));
        } else {
            lore.add(MessageSender.gm("&7[&3*&7] &7\u6307\u5b9a\u7ade\u6280\u573a &f[{arena}]", player, "arena", new String[]{arenaDisplayName}));
        }
        lore.add("");
        lore.add(MessageSender.gm("&7\u518d\u6b21\u70b9\u51fb\u6b64\u5904\u53ef&c\u53d6\u6d88&7\u5339\u914d", player));
        return new ItemCreator(ViaVersion.getGoldenAxeMaterial(), 1, 0, displayName, lore, null, Enchantment.LUCK, true).get();
    }

    public static ItemStack getRecords(String pn, int num) {
        String editName;
        Player p = Bukkit.getPlayerExact((String)pn);
        String displayName = MessageSender.gm("&a\u4f5c\u6218\u7f16\u53f7 &2#{num}", p, "num", new String[]{"" + num});
        List<String> lore = new ArrayList<String>();
        RecordCache recordCache = Main.getInstance().getCacheHandler().getRecord();
        ArenaInfoCache arenaInfoCache = Main.getInstance().getCacheHandler().getArenaInfo();
        Record record = recordCache.getRecords(pn).get(num);
        String result = null;
        if (record.getResult() == 0) {
            result = "&a[v]\u80dc\u5229";
        }
        if (record.getResult() == 1) {
            result = "&c[x]\u8d25\u5317";
        }
        if (record.getResult() == 2) {
            result = "&6[=]\u5e73\u5c40";
        }
        String server = MessageSender.gm("&7&m\u672a\u8bb0\u5f55&r", p);
        if (record.getServerName() != null) {
            server = record.getServerName().replace("&", "\u00a7");
        }
        String damage = MessageSender.gm("&7&m\u672a\u8bb0\u5f55&r", p);
        if (record.getDamage() != 0.0) {
            BigDecimal bg = BigDecimal.valueOf(record.getDamage());
            damage = bg.setScale(1, 4).doubleValue() + "";
        }
        String maxDamage = MessageSender.gm("&7&m\u672a\u8bb0\u5f55&r", p);
        if (record.getMaxDamage() != 0.0) {
            BigDecimal bg = BigDecimal.valueOf(record.getMaxDamage());
            maxDamage = bg.setScale(1, 4).doubleValue() + "";
        }
        String arenaName = MessageSender.gm("&7&m\u672a\u8bb0\u5f55&r", p);
        if (record.getArenaEditName() != null && arenaInfoCache.get(editName = record.getArenaEditName()) != null) {
            arenaName = arenaInfoCache.get(editName).getDisplayName() != null ? arenaInfoCache.get(editName).getDisplayName().replace("&", "\u00a7") : editName;
        }
        String expChangeStr = MessageSender.gm("&7&m\u672a\u8bb0\u5f55&r", p);
        if (record.getExpChange() != 0) {
            int expChange = record.getExpChange();
            expChangeStr = expChange > 0 ? MessageSender.gm("\u83b7\u5f97", p) + expChange : MessageSender.gm("\u635f\u5931", p) + -expChange;
        }
        String startWayStr = MessageSender.gm("&7&m\u672a\u8bb0\u5f55&r", p);
        int startWay = record.getStartWay();
        if (startWay == 1) {
            startWayStr = MessageSender.gm("\u5339\u914d\u8d5b", p);
        }
        if (startWay == 2) {
            startWayStr = MessageSender.gm("\u9080\u8bf7\u8d5b", p);
        }
        if (startWay == 3) {
            startWayStr = MessageSender.gm("\u5f3a\u5236\u8d5b", p);
        }
        String result_string = MessageSender.gm(result, p);
        try {
            lore = MessageSender.gml(" |&b\u7ed3\u679c &f[right] {result}|&b\u5bf9\u624b &f[right] &e{opponent}|&b\u5730\u56fe &f[right] &e{arena}|&b\u65e5\u671f &f[right] &e{date}|&b\u8017\u65f6 &f[right] &e{time}\u79d2|&b\u7ecf\u9a8c &f[right] &e{exp}|&b\u7c7b\u578b &f[right] &e{type}|&b\u4f24\u5bb3\u8f93\u51fa  &f[right] &e{damage}|&b\u6700\u5927\u8f93\u51fa  &f[right] &e{maxdamage}|&b\u5bf9\u6218\u533a\u670d  &f[right] &e{server}|&r", p, "result opponent arena date time exp type damage maxdamage server", new String[]{result_string, record.getOpponentName(), arenaName, record.getDate(), record.getTime() + "", expChangeStr, startWayStr, damage, maxDamage, server});
            lore.add("");
            lore.add(MessageSender.gm("&f[right] &b\u5de6\u952e&7\u5c06\u672c\u6218\u7ee9\u5206\u4eab\u5230\u804a\u5929\u6846", p));
            lore.add(MessageSender.gm("&f[right] &d\u53f3\u952e&7\u5c06\u672c\u6218\u7ee9\u6253\u5370\u5230\u7eb8\u4e0a", p));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ItemCreator(Material.PAPER, 1, 0, displayName, lore, null, null, true).get();
    }

    public static ItemStack getGoodShowed(String pn, Good good) {
        Player p = Bukkit.getPlayerExact((String)pn);
        ItemStack item = good.getItemStack();
        double price = good.getPrice();
        String description = good.getDescription();
        int salesVolume = good.getSalesVolume();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        String dec = Dec.getStr(5);
        lore.add(dec);
        lore.add(MessageSender.gm("&b\u5546\u54c1Lore &f&l>>", p));
        boolean hasLore = true;
        if (item.hasItemMeta()) {
            if (item.getItemMeta().getLore() != null) {
                lore.addAll(item.getItemMeta().getLore());
            } else {
                hasLore = false;
            }
        } else {
            hasLore = false;
        }
        if (!hasLore) {
            lore.add(MessageSender.gm("&7\u65e0", p));
        }
        lore.add(dec);
        lore.add(MessageSender.gm("&b\u5546\u54c1\u4fe1\u606f &f&l>>", p));
        if (description != null) {
            lore.add(MessageSender.gm("&6\u5907\u6ce8\uff1a", p) + description.replace("&", "\u00a7").replace("{player}", pn).replace("_", " "));
        } else {
            lore.add(MessageSender.gm("&6\u5907\u6ce8\uff1a &7\u65e0", p));
        }
        lore.add(MessageSender.gm("&6\u9500\u91cf\uff1a &e{volumn}", p, "volumn", new String[]{"" + salesVolume}));
        lore.add(MessageSender.gm("&6\u4ef7\u683c\uff1a &e{price}", p, "price", new String[]{"" + price}));
        PointCache pointCache = Main.getInstance().getCacheHandler().getPoint();
        double points = pointCache.get(pn);
        lore.add(MessageSender.gm("&6\u4f59\u989d\uff1a &e{points}", p, "points", new String[]{"" + points}));
        lore.add(dec);
        DanHandler dh = Main.getInstance().getDanHandler();
        if (good.getDan() != null && dh.getDanByName(good.getDan()) != null) {
            CustomDan danNeeded = dh.getDanByName(good.getDan());
            CustomDan playerDan = dh.getPlayerDan(p.getName());
            if (playerDan != null && playerDan.getNum() >= danNeeded.getNum()) {
                lore.add(MessageSender.gm("&f[&a!&f]&r {dan} &7\u53ca\u4ee5\u4e0a\u6bb5\u4f4d\u7684\u73a9\u5bb6\u4e13\u4eab\u5151\u6362\u7269", p, "dan", new String[]{danNeeded.getDisplayName().replace("&", "\u00a7")}));
                lore.add("");
                if (points >= price) {
                    lore.add(MessageSender.gm("&a[v]\u70b9\u51fb\u8d2d\u4e70", p));
                } else {
                    lore.add(MessageSender.gm("&c[x]\u4f59\u989d\u4e0d\u8db3", p));
                }
                lore.set(0, MessageSender.gm("&a[\u5df2\u89e3\u9501]&r", p));
            } else {
                lore.add("");
                lore.add(MessageSender.gm("&7\u8fbe\u5230\u6bb5\u4f4d {dan} &7\u540e\u89e3\u9501", p, "dan", new String[]{danNeeded.getDisplayName().replace("&", "\u00a7")}));
                lore.set(0, MessageSender.gm("&c[\u672a\u89e3\u9501]&r", p));
            }
        } else {
            lore.remove(0);
            lore.add("");
            if (points >= price) {
                lore.add(MessageSender.gm("&a[v]\u70b9\u51fb\u8d2d\u4e70", p));
            } else {
                lore.add(MessageSender.gm("&c[x]\u4f59\u989d\u4e0d\u8db3", p));
            }
        }
        ItemStack itemShowed = item.clone();
        ItemMeta im = itemShowed.getItemMeta();
        im.setLore(lore);
        itemShowed.setItemMeta(im);
        return itemShowed;
    }
}

