/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.ranking.hologram;

import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.valorin.ranking.hologram.HologramPlugin;
import eu.decentsoftware.holograms.api.DHAPI;
import java.util.List;
import me.arasple.mc.trhologram.api.TrHologramAPI;
import me.arasple.mc.trhologram.api.hologram.HologramBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HologramInstance {
    private Object hologram;
    private final HologramPlugin hologramPlugin;
    private final RankingType rankingType;
    private List<String> content;
    private final ItemStack itemStack;

    public HologramInstance(Plugin plugin, HologramPlugin hologramPlugin, Location location, RankingType rankingType, List<String> content, ItemStack itemStack) {
        this.hologramPlugin = hologramPlugin;
        this.rankingType = rankingType;
        this.content = content;
        this.itemStack = itemStack;
        switch (hologramPlugin) {
            case HOLOGRAPHIC_DISPLAY: {
                Bukkit.getScheduler().runTask(plugin, () -> {
                    this.hologram = HologramsAPI.createHologram((Plugin)plugin, (Location)location);
                    ((Hologram)this.hologram).appendItemLine(itemStack);
                    content.forEach(arg_0 -> ((Hologram)((Hologram)this.hologram)).appendTextLine(arg_0));
                });
                break;
            }
            case TRHOLOGRAM: {
                HologramBuilder builder = TrHologramAPI.builder((Location)location);
                builder.append(viewer -> itemStack);
                content.forEach(arg_0 -> ((HologramBuilder)builder).append(arg_0));
                this.hologram = builder.build();
                break;
            }
            case CMI: {
                this.hologram = new CMIHologram(rankingType.name(), location);
                ((CMIHologram)this.hologram).setLoc(location);
                ((CMIHologram)this.hologram).setLines(content);
                ((CMIHologram)this.hologram).refresh();
                break;
            }
            case DECENT_HOLOGRAM: {
                this.hologram = DHAPI.createHologram((String)rankingType.name(), (Location)location, content);
            }
        }
    }

    public void destroy() {
        switch (this.hologramPlugin) {
            case HOLOGRAPHIC_DISPLAY: {
                ((Hologram)this.hologram).delete();
                break;
            }
            case TRHOLOGRAM: {
                ((me.arasple.mc.trhologram.module.display.Hologram)this.hologram).destroy();
                break;
            }
            case CMI: {
                ((CMIHologram)this.hologram).remove();
                break;
            }
            case DECENT_HOLOGRAM: {
                ((eu.decentsoftware.holograms.api.holograms.Hologram)this.hologram).delete();
            }
        }
    }

    public void refresh(List<String> content) {
        switch (this.hologramPlugin) {
            case HOLOGRAPHIC_DISPLAY: {
                ((Hologram)this.hologram).clearLines();
                content.forEach(arg_0 -> ((Hologram)((Hologram)this.hologram)).appendTextLine(arg_0));
                break;
            }
            case TRHOLOGRAM: {
                HologramBuilder builder = ((me.arasple.mc.trhologram.module.display.Hologram)this.hologram).rebuild();
                content.forEach(arg_0 -> ((HologramBuilder)builder).append(arg_0));
                this.hologram = builder.build();
                break;
            }
            case CMI: {
                ((CMIHologram)this.hologram).setLines(content);
                ((CMIHologram)this.hologram).refresh();
                break;
            }
            case DECENT_HOLOGRAM: {
                DHAPI.setHologramLines((eu.decentsoftware.holograms.api.holograms.Hologram)((eu.decentsoftware.holograms.api.holograms.Hologram)this.hologram), content);
            }
        }
        this.content = content;
    }

    public void refresh(Location location) {
        switch (this.hologramPlugin) {
            case HOLOGRAPHIC_DISPLAY: {
                ((Hologram)this.hologram).teleport(location);
                break;
            }
            case TRHOLOGRAM: {
                ((me.arasple.mc.trhologram.module.display.Hologram)this.hologram).destroy();
                HologramBuilder builder = TrHologramAPI.builder((Location)location);
                builder.append(viewer -> this.itemStack);
                this.content.forEach(arg_0 -> ((HologramBuilder)builder).append(arg_0));
                this.hologram = builder.build();
                break;
            }
            case CMI: {
                ((CMIHologram)this.hologram).setLoc(location);
                ((CMIHologram)this.hologram).refresh();
                break;
            }
            case DECENT_HOLOGRAM: {
                DHAPI.moveHologram((eu.decentsoftware.holograms.api.holograms.Hologram)((eu.decentsoftware.holograms.api.holograms.Hologram)this.hologram), (Location)location);
            }
        }
    }

    public RankingType getRankingType() {
        return this.rankingType;
    }

    public static enum RankingType {
        WIN,
        KD;

    }
}

