/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.ranking.sign;

import com.valorin.Main;
import com.valorin.caches.AreaCache;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.data.encapsulation.RankingSign;
import com.valorin.ranking.RankingData;
import com.valorin.util.ViaVersion;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SignManager {
    public static int refreshTaskId = -1;

    public static void initialize() {
        int interval = Main.getInstance().getConfigManager().getSignRefreshInterval();
        interval = interval < 10 ? 200 : (interval *= 20);
        new BukkitRunnable(){

            public void run() {
                refreshTaskId = this.getTaskId();
                SignManager.refresh(true);
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 100L, (long)interval);
    }

    public static void refresh(boolean auto) {
        AreaCache cache = Main.getInstance().getCacheHandler().getArea();
        List<RankingSign> rankingSignList = cache.getRankingSignList();
        int signNumber = rankingSignList.size();
        if (signNumber == 0) {
            return;
        }
        int successes = 0;
        RankingData rankingData = Main.getInstance().getRanking();
        for (RankingSign rankingSign : rankingSignList) {
            String line;
            int i;
            Number value;
            String playerName;
            Block signBlock;
            Material blockType;
            Location location = rankingSign.getLocation();
            if (location == null || !ViaVersion.isSignPostMaterial(blockType = (signBlock = location.getBlock()).getType()) && !ViaVersion.isWallSignMaterial(blockType)) continue;
            String rankingType = rankingSign.getRankingType();
            int ranking = rankingSign.getRanking();
            if (rankingType.equalsIgnoreCase("kd")) {
                playerName = rankingData.getPlayerByKDRank(ranking);
                value = rankingData.getKDValue(playerName);
            } else {
                playerName = rankingData.getPlayerByWinRank(ranking);
                value = rankingData.getWinValue(playerName);
            }
            Sign sign = (Sign)signBlock.getState();
            List<String> lines = rankingSign.getText();
            if (playerName != null) {
                for (i = 0; i < 4; ++i) {
                    line = lines.get(i);
                    sign.setLine(i, line.replace("%p", playerName).replace("%r", "" + ranking).replace("%v", "" + value));
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    line = lines.get(i);
                    sign.setLine(i, line.replace("%p", MessageSender.gm("\u865a\u4f4d\u4ee5\u5f85")).replace("%r", "-").replace("%v", "-"));
                }
            }
            sign.update();
            ++successes;
        }
        if (auto) {
            Bukkit.getConsoleSender().sendMessage(MessageSender.gm("&7\u6392\u884c\u6728\u724c\u5df2\u81ea\u52a8\u5237\u65b0...\u6210\u529f\u5237\u65b0\u6570:{successes}/{total}", null, "total successes", new String[]{"" + signNumber, "" + successes}));
        }
    }

    public static void reload() {
        if (refreshTaskId != -1) {
            Bukkit.getScheduler().cancelTask(refreshTaskId);
        }
        SignManager.initialize();
    }
}

