/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.util;

import com.valorin.util.ViaVersion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCreator {
    private final ItemStack itemStack;

    public ItemCreator(Material material, int amount, short s, String displayName, List<String> lore, String mark, Enchantment enchantment, boolean hideFlag) {
        ItemStack itemStack = new ItemStack(material, amount, s);
        ItemMeta im = itemStack.getItemMeta();
        if (displayName != null) {
            im.setDisplayName(displayName);
            itemStack.setItemMeta(im);
        }
        if (lore != null) {
            ArrayList<String> list = new ArrayList<String>();
            if (mark != null) {
                list.add(mark);
            }
            list.addAll(lore);
            im.setLore(list);
            itemStack.setItemMeta(im);
        }
        if (enchantment != null) {
            im.addEnchant(enchantment, 1, true);
            itemStack.setItemMeta(im);
        }
        if (hideFlag) {
            if (ViaVersion.isHasItemFlagMethod()) {
                im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            }
            itemStack.setItemMeta(im);
        }
        this.itemStack = itemStack;
    }

    public ItemStack get() {
        return this.itemStack;
    }
}

