/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.logging.log4j.Logger;

public class FullDataDownSampler {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public static CompletableFuture<IFullDataSource> createDownSamplingFuture(DhSectionPos newTarget, IFullDataSourceProvider provider) {
        return FullDataDownSampler.createDownSamplingFuture(CompleteFullDataSource.createEmpty(newTarget), provider);
    }

    public static CompletableFuture<IFullDataSource> createDownSamplingFuture(CompleteFullDataSource target, IFullDataSourceProvider provider) {
        ArrayList<CompletableFuture<IFullDataSource>> futures;
        int sectionSizeNeeded = 1 << target.getDataDetailLevel();
        DhLodPos basePos = target.getSectionPos().getSectionBBoxPos().getCornerLodPos((byte)6);
        if (sectionSizeNeeded <= 6) {
            futures = new ArrayList<CompletableFuture<IFullDataSource>>(sectionSizeNeeded * sectionSizeNeeded);
            for (int xOffset = 0; xOffset < sectionSizeNeeded; ++xOffset) {
                for (int zOffset = 0; zOffset < sectionSizeNeeded; ++zOffset) {
                    CompletionStage<IFullDataSource> future = provider.readAsync(new DhSectionPos(6, basePos.x + xOffset, basePos.z + zOffset));
                    future = future.whenComplete((source, ex) -> {
                        if (ex == null && source != null && source instanceof CompleteFullDataSource) {
                            FullDataDownSampler.downSample(target, (CompleteFullDataSource)source);
                        } else if (ex != null) {
                            LOGGER.error("Error while down sampling", ex);
                        }
                    });
                    futures.add((CompletableFuture<IFullDataSource>)future);
                }
            }
        } else {
            futures = new ArrayList(CompleteFullDataSource.WIDTH * CompleteFullDataSource.WIDTH);
            int multiplier = sectionSizeNeeded / CompleteFullDataSource.WIDTH;
            for (int xOffset = 0; xOffset < CompleteFullDataSource.WIDTH; ++xOffset) {
                for (int zOffset = 0; zOffset < CompleteFullDataSource.WIDTH; ++zOffset) {
                    CompletionStage<IFullDataSource> future = provider.readAsync(new DhSectionPos(6, basePos.x + xOffset * multiplier, basePos.z + zOffset * multiplier));
                    future = future.whenComplete((source, ex) -> {
                        if (ex == null && source != null && source instanceof CompleteFullDataSource) {
                            FullDataDownSampler.downSample(target, (CompleteFullDataSource)source);
                        } else if (ex != null) {
                            LOGGER.error("Error while down sampling", ex);
                        }
                    });
                    futures.add((CompletableFuture<IFullDataSource>)future);
                }
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> target);
    }

    public static void downSample(CompleteFullDataSource target, CompleteFullDataSource source) {
        LodUtil.assertTrue(target.getSectionPos().overlapsExactly(source.getSectionPos()));
        LodUtil.assertTrue(target.getDataDetailLevel() > source.getDataDetailLevel());
        byte detailDiff = (byte)(target.getDataDetailLevel() - source.getDataDetailLevel());
        DhSectionPos trgPos = target.getSectionPos();
        DhSectionPos srcPos = source.getSectionPos();
        if (detailDiff >= 6) {
            int sourceSectionPerTargetData = 1 << detailDiff - 6;
            if (srcPos.getX() % sourceSectionPerTargetData != 0 || srcPos.getZ() % sourceSectionPerTargetData != 0) {
                return;
            }
            DhLodPos trgOffset = trgPos.getMinCornerLodPos(target.getDataDetailLevel());
            DhLodPos srcOffset = srcPos.getSectionBBoxPos().convertToDetailLevel(target.getDataDetailLevel());
            int offsetX = trgOffset.x - srcOffset.x;
            int offsetZ = trgOffset.z - srcOffset.z;
            LodUtil.assertTrue(offsetX >= 0 && offsetX < CompleteFullDataSource.WIDTH && offsetZ >= 0 && offsetZ < CompleteFullDataSource.WIDTH);
            target.markNotEmpty();
            source.get(0, 0).deepCopyTo(target.get(offsetX, offsetZ));
        } else if (detailDiff > 0) {
            int srcDataPerTrgData = 1 << detailDiff;
            int overlappedTrgDataSize = CompleteFullDataSource.WIDTH / srcDataPerTrgData;
            DhLodPos trgOffset = trgPos.getMinCornerLodPos(target.getDataDetailLevel());
            DhLodPos srcOffset = srcPos.getSectionBBoxPos().getCornerLodPos(target.getDataDetailLevel());
            int offsetX = trgOffset.x - srcOffset.x;
            int offsetZ = trgOffset.z - srcOffset.z;
            LodUtil.assertTrue(offsetX >= 0 && offsetX < CompleteFullDataSource.WIDTH && offsetZ >= 0 && offsetZ < CompleteFullDataSource.WIDTH);
            target.markNotEmpty();
            for (int ox = 0; ox < overlappedTrgDataSize; ++ox) {
                for (int oz = 0; oz < overlappedTrgDataSize; ++oz) {
                    SingleColumnFullDataAccessor column = target.get(ox + offsetX, oz + offsetZ);
                    column.downsampleFrom(source.subView(srcDataPerTrgData, ox * srcDataPerTrgData, oz * srcDataPerTrgData));
                }
            }
        } else {
            LodUtil.assertNotReach();
        }
    }
}

