/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.accessor;

import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.IFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;

public class FullDataArrayAccessor
implements IFullDataAccessor {
    protected final FullDataPointIdMap mapping;
    protected final long[][] dataArrays;
    protected final int width;
    protected final int dataWidth;
    protected final int offset;

    public FullDataArrayAccessor(FullDataPointIdMap mapping, long[][] dataArrays, int width) {
        if (dataArrays.length != width * width) {
            throw new IllegalArgumentException("tried constructing dataArrayView with invalid input!");
        }
        this.dataArrays = dataArrays;
        this.width = width;
        this.dataWidth = width;
        this.mapping = mapping;
        this.offset = 0;
    }

    public FullDataArrayAccessor(FullDataArrayAccessor source, int width, int offsetX, int offsetZ) {
        if (source.width < width || source.width < width + offsetX || source.width < width + offsetZ) {
            throw new IllegalArgumentException("tried constructing dataArrayView subview with invalid input!");
        }
        this.dataArrays = source.dataArrays;
        this.width = width;
        this.dataWidth = source.dataWidth;
        this.mapping = source.mapping;
        this.offset = source.offset + offsetX * this.dataWidth + offsetZ;
    }

    @Override
    public FullDataArrayAccessor subView(int width, int xOffset, int zOffset) {
        return new FullDataArrayAccessor(this, width, xOffset, zOffset);
    }

    public void shadowCopyTo(FullDataArrayAccessor target) {
        if (target.width != this.width) {
            throw new IllegalArgumentException("Target view must have same size as this view");
        }
        if (target.mapping.equals(this.mapping)) {
            for (int x = 0; x < this.width; ++x) {
                System.arraycopy(this.dataArrays, this.offset + x * this.dataWidth, target.dataArrays, target.offset + x * target.dataWidth, this.width);
            }
        } else {
            int[] remappedIds = target.mapping.mergeAndReturnRemappedEntityIds(this.mapping);
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.width; ++z) {
                    long[] currentData = this.dataArrays[this.offset + x * this.dataWidth + z];
                    if (currentData == null) continue;
                    long[] newData = new long[currentData.length];
                    for (int dataPointIndex = 0; dataPointIndex < newData.length; ++dataPointIndex) {
                        newData[dataPointIndex] = FullDataPointUtil.remap(remappedIds, currentData[dataPointIndex]);
                    }
                    target.dataArrays[target.offset + x * target.dataWidth + z] = newData;
                }
            }
        }
    }

    public void downsampleFrom(FullDataArrayAccessor incomingFullDataAccessor) {
        LodUtil.assertTrue(incomingFullDataAccessor.width >= this.width && incomingFullDataAccessor.width % this.width == 0);
        int dataPointsPerWidthUnit = incomingFullDataAccessor.width / this.width;
        for (int xOffset = 0; xOffset < this.width; ++xOffset) {
            for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                FullDataArrayAccessor subView = incomingFullDataAccessor.subView(dataPointsPerWidthUnit, xOffset * dataPointsPerWidthUnit, zOffset * dataPointsPerWidthUnit);
                SingleColumnFullDataAccessor column = this.get(xOffset, zOffset);
                column.downsampleFrom(subView);
            }
        }
    }

    @Override
    public FullDataPointIdMap getMapping() {
        return this.mapping;
    }

    @Override
    public SingleColumnFullDataAccessor get(int index) {
        return this.get(index / this.width, index % this.width);
    }

    @Override
    public SingleColumnFullDataAccessor get(int relativeX, int relativeZ) {
        int dataArrayIndex = relativeX * this.width + relativeZ + this.offset;
        if (dataArrayIndex >= this.dataArrays.length) {
            LodUtil.assertNotReach("FullDataArrayAccessor.get() called with a relative position that is outside the data source. \nsource width: [" + this.width + "] source offset: [" + this.offset + "]\ngiven relative pos X: [" + relativeX + "] Z: [" + relativeZ + "]\ndataArrays.length: [" + this.dataArrays.length + "] dataArrayIndex: [" + dataArrayIndex + "].");
        }
        return new SingleColumnFullDataAccessor(this.mapping, this.dataArrays, dataArrayIndex);
    }

    @Override
    public int width() {
        return this.width;
    }
}

