/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.file.metaData.AbstractMetaDataContainerFile;
import com.seibel.distanthorizons.core.file.renderfile.RenderDataMetaFile;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import java.io.Closeable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class DataSourceReferenceTracker {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final boolean LOG_GARBAGE_COLLECTIONS = false;
    private static final long MS_BETWEEN_GARBAGE_CHECKS = TimeUnit.SECONDS.toMillis(60L);
    private static final long MS_TO_EXPIRE_DATA_SOURCE = TimeUnit.SECONDS.toMillis(60L);
    private static final ReferenceQueue<IFullDataSource> FULL_DATA_GARBAGE_COLLECTED_QUEUE = new ReferenceQueue();
    private static final ReferenceQueue<ColumnRenderSource> RENDER_DATA_GARBAGE_COLLECTED_QUEUE = new ReferenceQueue();
    private static final Set<FullDataSourceSoftRef> FULL_DATA_SOFT_REFS = ConcurrentHashMap.newKeySet();
    private static final Set<RenderDataSourceSoftRef> RENDER_DATA_SOFT_REFS = ConcurrentHashMap.newKeySet();
    private static final ThreadPoolExecutor GARBAGE_COLLECTOR_THREAD = ThreadUtil.makeSingleThreadPool("DataSourceReferenceTracker", ThreadUtil.MINIMUM_RELATIVE_PRIORITY);

    public static void startGarbageCollectorBackgroundThread() {
    }

    private static void garbageCollectorLoop() {
        while (true) {
            try {
                while (true) {
                    DataSourceReferenceTracker.runGarbageCollection();
                    Thread.sleep(MS_BETWEEN_GARBAGE_CHECKS);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Garbage collector thread interrupted.", (Throwable)e);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected data source garbage collector exception: " + e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static void runGarbageCollection() {
        DataSourceReferenceTracker.removeGarbageCollectedDataSources();
        DataSourceReferenceTracker.removeExpiredDataSources();
    }

    private static void removeGarbageCollectedDataSources() {
        FullDataSourceSoftRef garbageCollectedFullDataSoftRef = (FullDataSourceSoftRef)FULL_DATA_GARBAGE_COLLECTED_QUEUE.poll();
        while (garbageCollectedFullDataSoftRef != null) {
            garbageCollectedFullDataSoftRef.close();
            garbageCollectedFullDataSoftRef = (FullDataSourceSoftRef)FULL_DATA_GARBAGE_COLLECTED_QUEUE.poll();
        }
        RenderDataSourceSoftRef renderSoftRef = (RenderDataSourceSoftRef)RENDER_DATA_GARBAGE_COLLECTED_QUEUE.poll();
        while (renderSoftRef != null) {
            renderSoftRef.close();
            renderSoftRef = (RenderDataSourceSoftRef)RENDER_DATA_GARBAGE_COLLECTED_QUEUE.poll();
        }
    }

    private static void removeExpiredDataSources() {
        FULL_DATA_SOFT_REFS.removeIf(fullDataSoftRef -> {
            boolean remove;
            boolean bl = remove = fullDataSoftRef.isDataSourceExpired() || fullDataSoftRef.silentGet() == null;
            if (remove) {
                fullDataSoftRef.clear();
                fullDataSoftRef.close();
            }
            return remove;
        });
        RENDER_DATA_SOFT_REFS.removeIf(renderDataSoftRef -> {
            boolean remove;
            boolean bl = remove = renderDataSoftRef.isDataSourceExpired() || renderDataSoftRef.silentGet() == null;
            if (remove) {
                renderDataSoftRef.clear();
                renderDataSoftRef.close();
            }
            return remove;
        });
    }

    public static class FullDataSourceSoftRef
    extends AbstractDataSourceSoftTracker<FullDataMetaFile, IFullDataSource> {
        public FullDataSourceSoftRef(FullDataMetaFile metaFile, IFullDataSource data) {
            super(metaFile, data, FULL_DATA_GARBAGE_COLLECTED_QUEUE);
            FULL_DATA_SOFT_REFS.add(this);
        }

        @Override
        public void close() {
            FULL_DATA_SOFT_REFS.remove(this);
        }
    }

    public static class RenderDataSourceSoftRef
    extends AbstractDataSourceSoftTracker<RenderDataMetaFile, ColumnRenderSource> {
        public RenderDataSourceSoftRef(RenderDataMetaFile metaFile, ColumnRenderSource data) {
            super(metaFile, data, RENDER_DATA_GARBAGE_COLLECTED_QUEUE);
            RENDER_DATA_SOFT_REFS.add(this);
        }

        @Override
        public void close() {
            RENDER_DATA_SOFT_REFS.remove(this);
        }
    }

    public static abstract class AbstractDataSourceSoftTracker<TMetaFile extends AbstractMetaDataContainerFile, TDataSource>
    extends SoftReference<TDataSource>
    implements Closeable {
        public final TMetaFile metaFile;
        public final long createdMsTime;
        private long expirationMsTime;

        public AbstractDataSourceSoftTracker(TMetaFile metaFile, TDataSource dataSource, ReferenceQueue<TDataSource> referenceQueue) {
            super(dataSource, referenceQueue);
            this.metaFile = metaFile;
            this.createdMsTime = System.currentTimeMillis();
            this.expirationMsTime = System.currentTimeMillis();
        }

        public void updateLastAccessedTime() {
            this.expirationMsTime = System.currentTimeMillis() + MS_TO_EXPIRE_DATA_SOURCE;
        }

        public long getExpirationMsTime() {
            return this.expirationMsTime;
        }

        public boolean isDataSourceExpired() {
            return this.expirationMsTime > System.currentTimeMillis();
        }

        @Override
        public TDataSource get() {
            this.updateLastAccessedTime();
            return (TDataSource)super.get();
        }

        public TDataSource silentGet() {
            return (TDataSource)super.get();
        }
    }
}

