/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderProxy;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import org.lwjgl.opengl.GL32;

public class DhApiRenderProxy
implements IDhApiRenderProxy {
    public static final DhApiRenderProxy INSTANCE = new DhApiRenderProxy();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    public int targetFrameBufferOverride = -1;

    private DhApiRenderProxy() {
    }

    @Override
    public DhApiResult<Boolean> clearRenderDataCache() {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            return DhApiResult.createFail("No world loaded");
        }
        Iterable<? extends IDhLevel> loadedLevels = world.getAllLoadedLevels();
        for (IDhLevel iDhLevel : loadedLevels) {
            if (!(iDhLevel instanceof IDhClientLevel)) continue;
            ((IDhClientLevel)iDhLevel).clearRenderCache();
        }
        return DhApiResult.createSuccess();
    }

    @Override
    public DhApiResult<Integer> getDhFrameBufferId() {
        int activeFrameBuffer = LodRenderer.getActiveFramebufferId();
        return activeFrameBuffer == -1 ? DhApiResult.createFail("DH's FrameBuffer hasn't been created and/or bound yet.", -1) : DhApiResult.createSuccess(activeFrameBuffer);
    }

    @Override
    public DhApiResult<Void> setTargetFrameBufferId(int frameBufferId) {
        if (frameBufferId != -1 && !GL32.glIsFramebuffer((int)frameBufferId)) {
            return DhApiResult.createFail("FrameBufferID [" + frameBufferId + "] isn't a valid FrameBuffer ID.");
        }
        this.targetFrameBufferOverride = frameBufferId;
        return DhApiResult.createSuccess();
    }

    @Override
    public DhApiResult<Integer> getTargetFrameBufferId() {
        return this.targetFrameBufferOverride == -1 ? DhApiResult.createSuccess("Default MC FrameBuffer in use.", MC_RENDER.getTargetFrameBuffer()) : DhApiResult.createSuccess("FrameBuffer override active.", this.targetFrameBufferOverride);
    }

    @Override
    public DhApiResult<Integer> getDhDepthTextureId() {
        int activeTexture = LodRenderer.getActiveDepthTextureId();
        return activeTexture == -1 ? DhApiResult.createFail("DH's depth texture hasn't been created and/or bound yet.", -1) : DhApiResult.createSuccess(activeTexture);
    }

    @Override
    public DhApiResult<Integer> getDhColorTextureId() {
        int activeTexture = LodRenderer.getActiveColorTextureId();
        return activeTexture == -1 ? DhApiResult.createFail("DH's color texture hasn't been created and/or bound yet.", -1) : DhApiResult.createSuccess(activeTexture);
    }
}

