/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.easyitem.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin1720.collections.CollectionsKt;
import kotlin1720.jvm.internal.Intrinsics;
import kotlin1720.text.CharsKt;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.neige.easyitem.EasyItem;
import pers.neige.easyitem.item.ItemGenerator;
import pers.neige.easyitem.manager.ItemConfigManager;
import pers.neige.easyitem.taboolib.module.nms.ItemTag;
import pers.neige.easyitem.taboolib.module.nms.ItemTagData;
import pers.neige.easyitem.taboolib.module.nms.ItemTagList;
import pers.neige.easyitem.taboolib.module.nms.NMSItemTagKt;
import pers.neige.easyitem.utils.ItemUtils;
import pers.neige.neigeitems.item.ItemConfig;
import pers.neige.neigeitems.utils.ConfigUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\tJ\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u000eJ(\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lpers/neige/easyitem/manager/ItemManager;", "Lpers/neige/easyitem/manager/ItemConfigManager;", "()V", "itemAmount", "", "getItemAmount", "()I", "items", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lpers/neige/easyitem/item/ItemGenerator;", "getItems", "()Ljava/util/concurrent/ConcurrentHashMap;", "addItem", "", "itemGenerator", "getItem", "id", "getItemStack", "Lorg/bukkit/inventory/ItemStack;", "getOriginConfig", "Lorg/bukkit/configuration/ConfigurationSection;", "getRealOriginConfig", "hasItem", "", "loadItems", "reload", "saveItem", "itemStack", "path", "cover", "EasyItem"})
public final class ItemManager
extends ItemConfigManager {
    @NotNull
    public static final ItemManager INSTANCE = new ItemManager();
    @NotNull
    private static final ConcurrentHashMap<String, ItemGenerator> items = new ConcurrentHashMap();

    private ItemManager() {
    }

    @NotNull
    public final ConcurrentHashMap<String, ItemGenerator> getItems() {
        return items;
    }

    public final int getItemAmount() {
        return this.getItemIds().size();
    }

    private final void loadItems() {
        for (Map.Entry entry : ((Map)this.getItemConfigs()).entrySet()) {
            String id = (String)entry.getKey();
            ItemConfig itemConfig = (ItemConfig)entry.getValue();
            ((Map)items).put(id, new ItemGenerator(itemConfig));
        }
    }

    private final void addItem(ItemGenerator itemGenerator) {
        ((Map)this.getItemConfigs()).put(itemGenerator.getId(), itemGenerator.getItemConfig());
        ((Map)items).put(itemGenerator.getId(), itemGenerator);
    }

    public final void reload() {
        this.reloadItemConfigs();
        items.clear();
        this.loadItems();
    }

    @Nullable
    public final ConfigurationSection getOriginConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemConfig itemConfig = this.getItemConfigs().get(id);
        return itemConfig != null && (itemConfig = itemConfig.getConfigSection()) != null ? ConfigUtils.clone((ConfigurationSection)itemConfig) : null;
    }

    @Nullable
    public final ConfigurationSection getRealOriginConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemConfig itemConfig = this.getItemConfigs().get(id);
        return itemConfig != null ? itemConfig.getConfigSection() : null;
    }

    @Nullable
    public final ItemGenerator getItem(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return items.get(id);
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemGenerator itemGenerator = items.get(id);
        return itemGenerator != null ? itemGenerator.getItemStack() : null;
    }

    public final boolean hasItem(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return items.containsKey(id);
    }

    /*
     * WARNING - void declaration
     */
    public final int saveItem(@NotNull ItemStack itemStack, @NotNull String id, @NotNull String path, boolean cover2) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (itemStack.getType() != Material.AIR) {
            File file = new File(EasyItem.INSTANCE.getPlugin().getDataFolder(), File.separator + "Items" + File.separator + path);
            if (!file.exists()) {
                file.createNewFile();
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(file)");
            YamlConfiguration config = yamlConfiguration;
            if (!this.hasItem(id) || cover2) {
                ConfigurationSection configurationSection = config.createSection(id);
                Intrinsics.checkNotNullExpressionValue((Object)configurationSection, (String)"config.createSection(id)");
                ConfigurationSection configSection = configurationSection;
                configSection.set("material", (Object)itemStack.getType().toString());
                if (itemStack.getDurability() > 0) {
                    configSection.set("damage", (Object)itemStack.getDurability());
                }
                if (itemStack.hasItemMeta()) {
                    ItemTagData itemTagData;
                    ItemTagData itemTagData2;
                    Object object;
                    Object object2;
                    Object it;
                    Object object3;
                    Object level;
                    Object object4;
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    ItemTag itemNBT = NMSItemTagKt.getItemTag(itemStack);
                    ItemTagData display = (ItemTagData)itemNBT.get("display");
                    itemNBT.remove("display");
                    try {
                        ItemMeta itemMeta2 = itemMeta;
                        boolean bl = itemMeta2 != null ? itemMeta2.hasCustomModelData() : false;
                        if (bl) {
                            configSection.set("custommodeldata", (Object)itemMeta.getCustomModelData());
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    ItemMeta itemMeta3 = itemMeta;
                    boolean bl = itemMeta3 != null ? itemMeta3.hasDisplayName() : false;
                    if (bl) {
                        configSection.set("name", (Object)itemMeta.getDisplayName());
                    }
                    ItemMeta itemMeta4 = itemMeta;
                    boolean bl2 = itemMeta4 != null ? itemMeta4.hasLore() : false;
                    if (bl2) {
                        configSection.set("lore", (Object)itemMeta.getLore());
                    }
                    ItemMeta itemMeta5 = itemMeta;
                    boolean bl3 = itemMeta5 != null ? itemMeta5.isUnbreakable() : false;
                    if (bl3) {
                        configSection.set("unbreakable", (Object)itemMeta.isUnbreakable());
                    }
                    ItemMeta itemMeta6 = itemMeta;
                    boolean bl4 = itemMeta6 != null ? itemMeta6.hasEnchants() : false;
                    if (bl4) {
                        ConfigurationSection configurationSection2 = configSection.createSection("enchantments");
                        Intrinsics.checkNotNullExpressionValue((Object)configurationSection2, (String)"configSection.createSection(\"enchantments\")");
                        ConfigurationSection enchantSection = configurationSection2;
                        Map map = itemMeta.getEnchants();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"itemMeta.enchants");
                        object4 = map.entrySet().iterator();
                        while (object4.hasNext()) {
                            Map.Entry entry = (Map.Entry)object4.next();
                            Enchantment enchant = (Enchantment)entry.getKey();
                            level = (Integer)entry.getValue();
                            enchantSection.set(enchant.getName(), level);
                        }
                    }
                    if ((object3 = itemMeta) != null && (object3 = object3.getItemFlags()) != null) {
                        it = object3;
                        boolean bl5 = false;
                        if (!((Collection)it).isEmpty()) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            level = (Iterable)it;
                            String string = "hideflags";
                            object2 = configSection;
                            boolean $i$f$map = false;
                            void var19_29 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void flag;
                                ItemFlag itemFlag = (ItemFlag)item$iv$iv;
                                object = destination$iv$iv;
                                boolean bl6 = false;
                                object.add(flag.name());
                            }
                            object = (List)destination$iv$iv;
                            object2.set(string, object);
                        }
                    }
                    if ((itemTagData2 = display) != null && (itemTagData2 = itemTagData2.asCompound()) != null) {
                        it = itemTagData2;
                        boolean bl7 = false;
                        ItemTagData itemTagData3 = (ItemTagData)((ItemTag)it).get("color");
                        if (itemTagData3 != null) {
                            int color = itemTagData3.asInt();
                            boolean bl8 = false;
                            String string = Integer.toString(color, CharsKt.checkRadix((int)16));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                            object2 = string;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                            String string2 = ((String)object2).toUpperCase(locale);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                            configSection.set("color", (Object)string2);
                        }
                    }
                    if ((itemTagData = display) != null && (itemTagData = itemTagData.asCompound()) != null) {
                        ItemTagList itemTagList;
                        ItemTagData itemTagData4;
                        String string;
                        ItemMeta cloneMeta;
                        it = object4 = itemTagData;
                        boolean bl9 = false;
                        ItemStack itemStack2 = itemStack.clone();
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"itemStack.clone()");
                        ItemStack itemClone = itemStack2;
                        ItemMeta itemMeta7 = cloneMeta = itemClone.getItemMeta();
                        if (itemMeta7 != null) {
                            itemMeta7.setDisplayName(cloneMeta.getDisplayName());
                        }
                        ItemMeta itemMeta8 = cloneMeta;
                        if (itemMeta8 != null) {
                            itemMeta8.setLore(cloneMeta.getLore());
                        }
                        itemClone.setItemMeta(cloneMeta);
                        ItemTagData itemTagData5 = (ItemTagData)NMSItemTagKt.getItemTag(itemClone).get("display");
                        ItemTag cloneDisplay = itemTagData5 != null ? itemTagData5.asCompound() : null;
                        Object object5 = (ItemTagData)((ItemTag)it).get("Name");
                        if (object5 != null && (object5 = (string = ((ItemTagData)object5).asString())) != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"asString()");
                            String name2 = string;
                            boolean bl10 = false;
                            ItemTagData itemTagData6 = cloneDisplay;
                            if (!Intrinsics.areEqual((Object)name2, itemTagData6 != null && (itemTagData6 = (ItemTagData)((ItemTag)itemTagData6).get("Name")) != null ? itemTagData6.asString() : null)) {
                                configSection.set("illegalName", (Object)name2);
                            }
                        }
                        if ((itemTagData4 = (ItemTagData)((ItemTag)it).get("Lore")) != null && (itemTagData4 = (itemTagList = itemTagData4.asList())) != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)itemTagData4, (String)"asList()");
                            ItemTagList lore = itemTagList;
                            boolean bl11 = false;
                            ItemTagData itemTagData7 = cloneDisplay;
                            ItemTagList cloneLore = itemTagData7 != null && (itemTagData7 = (ItemTagData)((ItemTag)itemTagData7).get("Lore")) != null ? itemTagData7.asList() : null;
                            boolean illegal = false;
                            ItemTagList itemTagList2 = cloneLore;
                            if (!(itemTagList2 != null ? itemTagList2.size() == lore.size() : false)) {
                                illegal = true;
                            }
                            int flag = lore.size();
                            for (int i = 0; i < flag; ++i) {
                                ItemTagData itemTagData8;
                                if (Intrinsics.areEqual((Object)lore.get(i).asString(), (itemTagData8 = cloneLore) != null && (itemTagData8 = ((ItemTagList)itemTagData8).get(i)) != null ? itemTagData8.asString() : null)) continue;
                                illegal = true;
                            }
                            if (illegal) {
                                Collection<String> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Iterable i = lore;
                                object = "illegalLore";
                                ConfigurationSection configurationSection3 = configSection;
                                boolean $i$f$map = false;
                                void var27_45 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    ItemTagData itemTagData9 = (ItemTagData)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl12 = false;
                                    collection.add(it2.asString());
                                }
                                collection = (List)destination$iv$iv;
                                configurationSection3.set((String)object, (Object)collection);
                            }
                        }
                    }
                    if (!itemNBT.isEmpty()) {
                        configSection.set("nbt", ItemUtils.toMap(itemNBT, (List<String>)ItemUtils.INSTANCE.getInvalidNBT()));
                    }
                }
                config.save(file);
                this.addItem(new ItemGenerator(new ItemConfig(id, file, config)));
                if (cover2) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public static /* synthetic */ int saveItem$default(ItemManager itemManager, ItemStack itemStack, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string + ".yml";
        }
        return itemManager.saveItem(itemStack, string, string2, bl);
    }

    static {
        INSTANCE.loadItems();
    }
}

