/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.PlaceholderInjectable;
import com.willfp.eco.core.placeholder.StaticPlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextExtensions;
import com.willfp.eco.util.NumberUtils;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.display.DescriptionPlaceholder;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchantLike;
import com.willfp.ecoenchants.enchant.UtilKt;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import com.willfp.ecoenchants.rarity.EnchantmentRarity;
import com.willfp.ecoenchants.target.EnchantmentTarget;
import com.willfp.ecoenchants.type.EnchantmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/willfp/ecoenchants/enchant/EcoEnchantLike;", "", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "getConfig", "()Lcom/willfp/eco/core/config/interfaces/Config;", "enchantment", "Lorg/bukkit/enchantments/Enchantment;", "getEnchantment", "()Lorg/bukkit/enchantments/Enchantment;", "enchantmentRarity", "Lcom/willfp/ecoenchants/rarity/EnchantmentRarity;", "getEnchantmentRarity", "()Lcom/willfp/ecoenchants/rarity/EnchantmentRarity;", "maximumLevel", "", "getMaximumLevel", "()I", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "getPlugin", "()Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "rawDisplayName", "", "getRawDisplayName", "()Ljava/lang/String;", "type", "Lcom/willfp/ecoenchants/type/EnchantmentType;", "getType", "()Lcom/willfp/ecoenchants/type/EnchantmentType;", "canEnchantItem", "", "item", "Lorg/bukkit/inventory/ItemStack;", "getRawDescription", "level", "player", "Lorg/bukkit/entity/Player;", "core-plugin"})
public interface EcoEnchantLike {
    @NotNull
    public Config getConfig();

    public int getMaximumLevel();

    @NotNull
    public EcoEnchantsPlugin getPlugin();

    @NotNull
    public Enchantment getEnchantment();

    @NotNull
    public String getRawDisplayName();

    @NotNull
    public EnchantmentType getType();

    @NotNull
    public EnchantmentRarity getEnchantmentRarity();

    public boolean canEnchantItem(@NotNull ItemStack var1);

    @NotNull
    public String getRawDescription(int var1, @Nullable Player var2);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nEcoEnchantLike.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoEnchantLike.kt\ncom/willfp/ecoenchants/enchant/EcoEnchantLike$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,139:1\n1549#2:140\n1620#2,3:141\n1774#2,4:144\n1747#2,3:151\n1271#2,2:154\n1285#2,4:156\n187#3,3:148\n125#3:160\n152#3,3:161\n*S KotlinDebug\n*F\n+ 1 EcoEnchantLike.kt\ncom/willfp/ecoenchants/enchant/EcoEnchantLike$DefaultImpls\n*L\n62#1:140\n62#1:141,3\n63#1:144,4\n81#1:151,3\n92#1:154,2\n92#1:156,4\n68#1:148,3\n100#1:160\n100#1:161,3\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        public static boolean canEnchantItem(@NotNull EcoEnchantLike $this, @NotNull ItemStack item) {
            boolean bl;
            block17: {
                Map.Entry element$iv;
                boolean bl2;
                boolean $i$f$any;
                Object $this$any$iv;
                Iterator iterator;
                block16: {
                    int n;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Iterable $this$map$iv = FastItemStackExtensions.fast((ItemStack)item).getEnchants(true).keySet();
                    boolean $i$f$map = false;
                    iterator = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Enchantment enchantment = (Enchantment)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(UtilKt.wrap((Enchantment)it));
                    }
                    Iterable $this$count$iv = (List)destination$iv$iv;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv2 : $this$count$iv) {
                            EcoEnchantLike it = (EcoEnchantLike)element$iv2;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)$this.getType()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    if (n >= $this.getType().getLimit()) {
                        return false;
                    }
                    Map map = FastItemStackExtensions.fast((ItemStack)item).getEnchants(true);
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchants(...)");
                    $this$any$iv = map;
                    $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl2 = false;
                    } else {
                        iterator = $this$any$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv2 = element$iv = (Map.Entry)iterator.next();
                            boolean bl5 = false;
                            Enchantment enchant = (Enchantment)element$iv2.getKey();
                            Intrinsics.checkNotNull((Object)enchant);
                            if (!UtilKt.conflictsWithDeep(enchant, $this.getEnchantment())) continue;
                            bl2 = true;
                            break block16;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return false;
                }
                if (FastItemStackExtensions.fast((ItemStack)item).getEnchants(true).size() >= AnvilSupportKt.infiniteIfNegative($this.getPlugin().getConfigYml().getInt("anvil.enchant-limit"))) {
                    return false;
                }
                if (item.getType() == Material.ENCHANTED_BOOK) {
                    return true;
                }
                if ($this instanceof EcoEnchant) {
                    $this$any$iv = ((EcoEnchant)$this).getTargets();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv = iterator.next();
                            EnchantmentTarget it = (EnchantmentTarget)((Object)element$iv);
                            boolean bl6 = false;
                            if (!it.matches(item)) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                } else {
                    bl = $this.getEnchantment().canEnchantItem(item);
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static String getRawDescription(@NotNull EcoEnchantLike $this, int level, @Nullable Player player) {
            String rawDescription;
            void $this$mapTo$iv$iv;
            Object object;
            List list = $this.getConfig().getSubsection("placeholders").getKeys(false);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
            Iterable $this$associateWith$iv = list;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            Iterator iterator = $this$associateWithTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv$iv = iterator.next();
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                String string2 = $this.getConfig().getString("placeholders." + (String)it);
                object.put(t, string2);
            }
            Map uncompiledPlaceholders = MapsKt.toMutableMap((Map)result$iv);
            uncompiledPlaceholders.put("placeholder", $this.getConfig().getString("placeholder"));
            Map $this$map$iv = uncompiledPlaceholders;
            boolean $i$f$map = false;
            $this$associateWithTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                object = destination$iv$iv;
                boolean bl = false;
                String id = (String)entry.getKey();
                String expr = (String)entry.getValue();
                Intrinsics.checkNotNull((Object)id);
                object.add(new DescriptionPlaceholder(id, NumberUtils.evaluateExpression((String)expr, (PlaceholderContext)PlaceholderContextExtensions.placeholderContext$default((Player)player, null, (PlaceholderInjectable)new PlaceholderInjectable(level){
                    final /* synthetic */ int $level;
                    {
                        this.$level = $level;
                    }

                    @NotNull
                    public List<InjectablePlaceholder> getPlaceholderInjections() {
                        return CollectionsKt.listOf((Object)new StaticPlaceholder("level", () -> getRawDescription.placeholders.1.1.getPlaceholderInjections$lambda$0(this.$level)));
                    }

                    public void addInjectablePlaceholder(@NotNull Iterable<? extends InjectablePlaceholder> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    }

                    public void clearInjectedPlaceholders() {
                    }

                    private static final String getPlaceholderInjections$lambda$0(int $level) {
                        return String.valueOf($level);
                    }
                }, null, (int)10, null))));
            }
            List placeholders2 = (List)destination$iv$iv;
            String string = $this.getConfig().getString("description");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String description = rawDescription = string;
            for (DescriptionPlaceholder placeholder : placeholders2) {
                String string3 = "%" + placeholder.getId() + "%";
                String string4 = NumberUtils.format((double)placeholder.getValue());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                description = StringsKt.replace$default((String)description, (String)string3, (String)string4, (boolean)false, (int)4, null);
            }
            return description;
        }
    }
}

