/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant;

import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.GUIHelperExtensions;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EnchantGUIKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/willfp/ecoenchants/enchant/EnchantmentScrollPane;", "Lcom/willfp/eco/core/gui/GUIComponent;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "defaultSlot", "Lcom/willfp/eco/core/gui/slot/Slot;", "size", "", "getSize", "()I", "getColumns", "getRows", "getSlotAt", "row", "column", "player", "Lorg/bukkit/entity/Player;", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "core-plugin"})
final class EnchantmentScrollPane
implements GUIComponent {
    @NotNull
    private final EcoEnchantsPlugin plugin;
    @NotNull
    private final Slot defaultSlot;
    private final int size;

    public EnchantmentScrollPane(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        TestableItem testableItem = Items.lookup((String)this.plugin.getConfigYml().getString("enchant-gui.empty-item"));
        Intrinsics.checkNotNullExpressionValue((Object)testableItem, (String)"lookup(...)");
        this.defaultSlot = GUIHelperExtensions.slot((TestableItem)testableItem);
        this.size = this.getRows() * this.getColumns();
    }

    @Nullable
    public Slot getSlotAt(int row, int column, @NotNull Player player, @NotNull Menu menu) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        int index = column + (row - 1) * this.getColumns() - 1;
        int page = menu.getPage(player);
        List list = (List)menu.getState(player, "enchants");
        if (list == null) {
            return this.defaultSlot;
        }
        List enchants = list;
        if (enchants.isEmpty()) {
            return this.defaultSlot;
        }
        EcoEnchant ecoEnchant = (EcoEnchant)CollectionsKt.getOrNull((List)enchants, (int)(index + this.size * (page - 1)));
        if (ecoEnchant == null) {
            return this.defaultSlot;
        }
        EcoEnchant enchant = ecoEnchant;
        return EnchantGUIKt.access$getInformationSlot(enchant, this.plugin, player);
    }

    public int getRows() {
        return this.plugin.getConfigYml().getInt("enchant-gui.enchant-area.height");
    }

    public int getColumns() {
        return this.plugin.getConfigYml().getInt("enchant-gui.enchant-area.width");
    }

    public final int getSize() {
        return this.size;
    }
}

