/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant.impl;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.placeholder.PlayerlessPlaceholder;
import com.willfp.eco.util.ListUtilsExtensions;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.display.EnchantmentFormattingKt;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchantLevel;
import com.willfp.ecoenchants.rarity.EnchantmentRarities;
import com.willfp.ecoenchants.rarity.EnchantmentRarity;
import com.willfp.ecoenchants.target.EnchantmentTarget;
import com.willfp.ecoenchants.target.EnchantmentTargets;
import com.willfp.ecoenchants.type.EnchantmentType;
import com.willfp.ecoenchants.type.EnchantmentTypes;
import com.willfp.libreforge.SilentViolationContext;
import com.willfp.libreforge.ViolationContext;
import com.willfp.libreforge.conditions.ConditionList;
import com.willfp.libreforge.conditions.Conditions;
import com.willfp.libreforge.slot.SlotType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010H\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u0016H\u0016J\u0010\u0010J\u001a\u0002092\u0006\u0010K\u001a\u000208H$J\u0013\u0010L\u001a\u00020\u001b2\b\u0010I\u001a\u0004\u0018\u00010MH\u0086\u0002J\u0010\u0010N\u001a\u0002092\u0006\u0010K\u001a\u000208H\u0016J\u0006\u0010O\u001a\u000208J\n\u0010P\u001a\u0004\u0018\u00010\u0007H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00030\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0015\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R$\u0010#\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016@WX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0019\u0010(\u001a\u00070)\u00a2\u0006\u0002\b*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001dR\u0014\u00104\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001dR\u0014\u00105\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001dR\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020907X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0019\u0010?\u001a\u00070\u0003\u00a2\u0006\u0002\b*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00102R\u001f\u0010A\u001a\r\u0012\t\u0012\u00070B\u00a2\u0006\u0002\b\u00170\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0019R\u0014\u0010D\u001a\u00020EX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010G\u00a8\u0006Q"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/EcoEnchantBase;", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "id", "", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "_config", "Lcom/willfp/eco/core/config/interfaces/Config;", "(Ljava/lang/String;Lcom/willfp/ecoenchants/EcoEnchantsPlugin;Lcom/willfp/eco/core/config/interfaces/Config;)V", "conditions", "Lcom/willfp/libreforge/conditions/ConditionList;", "getConditions", "()Lcom/willfp/libreforge/conditions/ConditionList;", "config", "getConfig", "()Lcom/willfp/eco/core/config/interfaces/Config;", "config$delegate", "Lkotlin/Lazy;", "conflictIds", "", "kotlin.jvm.PlatformType", "conflicts", "Lorg/bukkit/enchantments/Enchantment;", "Lorg/jetbrains/annotations/Nullable;", "getConflicts", "()Ljava/util/Set;", "conflictsWithEverything", "", "getConflictsWithEverything", "()Z", "context", "Lcom/willfp/libreforge/ViolationContext;", "getContext", "()Lcom/willfp/libreforge/ViolationContext;", "<set-?>", "enchantment", "getEnchantment", "()Lorg/bukkit/enchantments/Enchantment;", "setEnchantment", "(Lorg/bukkit/enchantments/Enchantment;)V", "enchantmentKey", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/NotNull;", "getEnchantmentKey", "()Lorg/bukkit/NamespacedKey;", "enchantmentRarity", "Lcom/willfp/ecoenchants/rarity/EnchantmentRarity;", "getEnchantmentRarity", "()Lcom/willfp/ecoenchants/rarity/EnchantmentRarity;", "getId", "()Ljava/lang/String;", "isObtainableThroughDiscovery", "isObtainableThroughEnchanting", "isObtainableThroughTrading", "levels", "", "", "Lcom/willfp/ecoenchants/enchant/EcoEnchantLevel;", "maximumLevel", "getMaximumLevel", "()I", "getPlugin", "()Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "rawDisplayName", "getRawDisplayName", "targets", "Lcom/willfp/ecoenchants/target/EnchantmentTarget;", "getTargets", "type", "Lcom/willfp/ecoenchants/type/EnchantmentType;", "getType", "()Lcom/willfp/ecoenchants/type/EnchantmentType;", "conflictsWithDirectly", "other", "createLevel", "level", "equals", "", "getLevel", "hashCode", "loadConfig", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nEcoEnchantBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoEnchantBase.kt\ncom/willfp/ecoenchants/enchant/impl/EcoEnchantBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,136:1\n1603#2,9:137\n1855#2:146\n1856#2:148\n1612#2:149\n1603#2,9:150\n1855#2:159\n1856#2:161\n1612#2:162\n1#3:147\n1#3:160\n1#3:163\n372#4,7:164\n*S KotlinDebug\n*F\n+ 1 EcoEnchantBase.kt\ncom/willfp/ecoenchants/enchant/impl/EcoEnchantBase\n*L\n52#1:137,9\n52#1:146\n52#1:148\n52#1:149\n56#1:150,9\n56#1:159\n56#1:161\n56#1:162\n52#1:147\n56#1:160\n117#1:164,7\n*E\n"})
public abstract class EcoEnchantBase
implements EcoEnchant {
    @NotNull
    private final String id;
    @NotNull
    private final EcoEnchantsPlugin plugin;
    @NotNull
    private final ViolationContext context;
    @NotNull
    private final Lazy config$delegate;
    public Enchantment enchantment;
    @NotNull
    private final Map<Integer, EcoEnchantLevel> levels;
    @NotNull
    private final Set<String> conflictIds;
    @NotNull
    private final NamespacedKey enchantmentKey;
    @NotNull
    private final String rawDisplayName;
    private final int maximumLevel;
    @NotNull
    private final Set<Enchantment> conflicts;
    @NotNull
    private final Set<EnchantmentTarget> targets;
    @NotNull
    private final EnchantmentType type;
    @NotNull
    private final EnchantmentRarity enchantmentRarity;
    @NotNull
    private final ConditionList conditions;
    private final boolean isObtainableThroughEnchanting;
    private final boolean isObtainableThroughTrading;
    private final boolean isObtainableThroughDiscovery;

    public EcoEnchantBase(@NotNull String id, @NotNull EcoEnchantsPlugin plugin, @Nullable Config _config) {
        String it;
        Object it$iv$iv;
        boolean bl;
        String it2;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Object $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.id = id;
        this.plugin = plugin;
        this.context = new ViolationContext((EcoPlugin)this.plugin, "enchantment " + this.id);
        this.config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Config>(_config, this){
            final /* synthetic */ Config $_config;
            final /* synthetic */ EcoEnchantBase this$0;
            {
                this.$_config = $_config;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Config invoke() {
                Config config2 = this.$_config;
                if (config2 == null) {
                    Config config3 = this.this$0.loadConfig();
                    config2 = config3;
                    Intrinsics.checkNotNull((Object)config3);
                }
                return config2;
            }
        }));
        this.levels = new LinkedHashMap();
        List list = this.getConfig().getStrings("conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        this.conflictIds = CollectionsKt.toSet((Iterable)list);
        NamespacedKey namespacedKey = NamespacedKey.minecraft((String)this.id);
        Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"minecraft(...)");
        this.enchantmentKey = namespacedKey;
        String string = this.getConfig().getString("display-name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.rawDisplayName = string;
        this.maximumLevel = this.getConfig().getInt("max-level");
        List list2 = this.getConfig().getStrings("conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
        Iterable iterable = list2;
        EcoEnchantBase ecoEnchantBase = this;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)it2)) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        ecoEnchantBase.conflicts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List list3 = this.getConfig().getStrings("targets");
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStrings(...)");
        $this$mapNotNull$iv = list3;
        ecoEnchantBase = this;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it2 = (String)element$iv$iv;
            boolean bl4 = false;
            if ((EnchantmentTarget)EnchantmentTargets.INSTANCE.get(it2) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        ecoEnchantBase.targets = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$mapNotNullTo$iv$iv = this.getConfig().getString("type");
        ecoEnchantBase = this;
        boolean bl5 = false;
        EnchantmentType enchantmentType = (EnchantmentType)EnchantmentTypes.INSTANCE.get(it);
        EnchantmentType enchantmentType2 = enchantmentType;
        if (enchantmentType == null) {
            Set set = EnchantmentTypes.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"values(...)");
            Object object = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            enchantmentType2 = (EnchantmentType)object;
        }
        ecoEnchantBase.type = enchantmentType2;
        it = this.getConfig().getString("rarity");
        ecoEnchantBase = this;
        boolean bl6 = false;
        EnchantmentRarity enchantmentRarity = (EnchantmentRarity)EnchantmentRarities.INSTANCE.get(it);
        EnchantmentRarity enchantmentRarity2 = enchantmentRarity;
        if (enchantmentRarity == null) {
            Set set = EnchantmentRarities.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"values(...)");
            Object object = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            enchantmentRarity2 = (EnchantmentRarity)object;
        }
        ecoEnchantBase.enchantmentRarity = enchantmentRarity2;
        List list4 = this.getConfig().getSubsections("conditions");
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getSubsections(...)");
        this.conditions = Conditions.INSTANCE.compile((Collection)list4, this.plugin.isLoaded() ? this.context.with("conditions") : (ViolationContext)SilentViolationContext.INSTANCE);
        this.isObtainableThroughEnchanting = this.getConfig().getBool("enchantable");
        this.isObtainableThroughTrading = this.getConfig().getBool("tradeable");
        this.isObtainableThroughDiscovery = this.getConfig().getBool("discoverable");
        new PlayerlessPlaceholder((EcoPlugin)this.plugin, this.id + "_name", () -> EcoEnchantBase._init_$lambda$4(this)).register();
        if (Bukkit.getPluginManager().getPermission("ecoenchants.fromtable." + this.id) == null) {
            Permission permission = new Permission("ecoenchants.fromtable." + this.id, "Allows getting " + this.id + " from an Enchanting Table", PermissionDefault.TRUE);
            if (Bukkit.getPluginManager().getPermission("ecoenchants.fromtable.*") == null) {
                Bukkit.getPluginManager().addPermission(new Permission("ecoenchants.fromtable.*", "Allows getting all enchantments from an Enchanting Table", PermissionDefault.TRUE));
            }
            Permission permission2 = Bukkit.getPluginManager().getPermission("ecoenchants.fromtable.*");
            Intrinsics.checkNotNull((Object)permission2);
            permission.addParent(permission2, true);
            Bukkit.getPluginManager().addPermission(permission);
        }
    }

    public /* synthetic */ EcoEnchantBase(String string, EcoEnchantsPlugin ecoEnchantsPlugin, Config config2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            config2 = null;
        }
        this(string, ecoEnchantsPlugin, config2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public final EcoEnchantsPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    protected final ViolationContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public final Config getConfig() {
        Lazy lazy = this.config$delegate;
        return (Config)lazy.getValue();
    }

    @Override
    @NotNull
    public Enchantment getEnchantment() {
        Enchantment enchantment = this.enchantment;
        if (enchantment != null) {
            return enchantment;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"enchantment");
        return null;
    }

    @ApiStatus.Internal
    public void setEnchantment(@NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"<set-?>");
        this.enchantment = enchantment;
    }

    @Override
    @NotNull
    public NamespacedKey getEnchantmentKey() {
        return this.enchantmentKey;
    }

    @Override
    @NotNull
    public String getRawDisplayName() {
        return this.rawDisplayName;
    }

    @Override
    public int getMaximumLevel() {
        return this.maximumLevel;
    }

    @Override
    public boolean getConflictsWithEverything() {
        return ListUtilsExtensions.containsIgnoreCase((Iterable)this.conflictIds, (String)"all") || ListUtilsExtensions.containsIgnoreCase((Iterable)this.conflictIds, (String)"everything");
    }

    @Override
    @NotNull
    public Set<Enchantment> getConflicts() {
        return this.conflicts;
    }

    @Override
    @NotNull
    public Set<EnchantmentTarget> getTargets() {
        return this.targets;
    }

    @Override
    @NotNull
    public EnchantmentType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public EnchantmentRarity getEnchantmentRarity() {
        return this.enchantmentRarity;
    }

    @Override
    @NotNull
    public ConditionList getConditions() {
        return this.conditions;
    }

    @Override
    public boolean isObtainableThroughEnchanting() {
        return this.isObtainableThroughEnchanting;
    }

    @Override
    public boolean isObtainableThroughTrading() {
        return this.isObtainableThroughTrading;
    }

    @Override
    public boolean isObtainableThroughDiscovery() {
        return this.isObtainableThroughDiscovery;
    }

    @Nullable
    protected Config loadConfig() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EcoEnchantLevel getLevel(int level) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, EcoEnchantLevel> map = this.levels;
        Integer key$iv = level;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            EcoEnchantLevel answer$iv = this.createLevel(level);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (EcoEnchantLevel)object;
    }

    @NotNull
    protected abstract EcoEnchantLevel createLevel(int var1);

    @Override
    public boolean conflictsWithDirectly(@NotNull Enchantment other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.conflictIds.contains(other.getKey().getKey());
    }

    public final boolean equals(@Nullable Object other) {
        return other instanceof EcoEnchant && Intrinsics.areEqual((Object)this.getEnchantmentKey(), (Object)((EcoEnchant)other).getEnchantmentKey());
    }

    public final int hashCode() {
        return this.getEnchantmentKey().hashCode();
    }

    @Override
    @NotNull
    public Set<SlotType> getSlots() {
        return EcoEnchant.DefaultImpls.getSlots(this);
    }

    @Override
    public boolean conflictsWith(@NotNull Enchantment other) {
        return EcoEnchant.DefaultImpls.conflictsWith(this, other);
    }

    @NotNull
    public String getID() {
        return EcoEnchant.DefaultImpls.getID(this);
    }

    @Override
    public boolean canEnchantItem(@NotNull ItemStack item) {
        return EcoEnchant.DefaultImpls.canEnchantItem(this, item);
    }

    @Override
    @NotNull
    public String getRawDescription(int level, @Nullable Player player) {
        return EcoEnchant.DefaultImpls.getRawDescription(this, level, player);
    }

    private static final String _init_$lambda$4(EcoEnchantBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return EnchantmentFormattingKt.getFormattedName(this$0, 0, false);
    }
}

