/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant.impl;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchantLike;
import com.willfp.ecoenchants.rarity.EnchantmentRarities;
import com.willfp.ecoenchants.rarity.EnchantmentRarity;
import com.willfp.ecoenchants.type.EnchantmentType;
import com.willfp.ecoenchants.type.EnchantmentTypes;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0013H\u0016R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/VanillaEcoEnchantLike;", "Lcom/willfp/ecoenchants/enchant/EcoEnchantLike;", "enchantment", "Lorg/bukkit/enchantments/Enchantment;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lorg/bukkit/enchantments/Enchantment;Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "Lorg/jetbrains/annotations/NotNull;", "getConfig", "()Lcom/willfp/eco/core/config/interfaces/Config;", "getEnchantment", "()Lorg/bukkit/enchantments/Enchantment;", "enchantmentRarity", "Lcom/willfp/ecoenchants/rarity/EnchantmentRarity;", "getEnchantmentRarity", "()Lcom/willfp/ecoenchants/rarity/EnchantmentRarity;", "maximumLevel", "", "getMaximumLevel", "()I", "getPlugin", "()Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "rawDisplayName", "", "getRawDisplayName", "()Ljava/lang/String;", "type", "Lcom/willfp/ecoenchants/type/EnchantmentType;", "getType", "()Lcom/willfp/ecoenchants/type/EnchantmentType;", "equals", "", "other", "", "hashCode", "core-plugin"})
public final class VanillaEcoEnchantLike
implements EcoEnchantLike {
    @NotNull
    private final Enchantment enchantment;
    @NotNull
    private final EcoEnchantsPlugin plugin;
    @NotNull
    private final Config config;
    @NotNull
    private final EnchantmentType type;
    @NotNull
    private final EnchantmentRarity enchantmentRarity;
    @NotNull
    private final String rawDisplayName;

    public VanillaEcoEnchantLike(@NotNull Enchantment enchantment, @NotNull EcoEnchantsPlugin plugin) {
        Object object;
        EnchantmentType enchantmentType;
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.enchantment = enchantment;
        this.plugin = plugin;
        Config config2 = this.getPlugin().getVanillaEnchantsYml().getSubsection(this.getEnchantment().getKey().getKey());
        Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"getSubsection(...)");
        this.config = config2;
        Object object2 = (EnchantmentType)EnchantmentTypes.INSTANCE.get(this.getPlugin().getVanillaEnchantsYml().getString(this.getEnchantment().getKey().getKey() + ".type"));
        if (object2 == null) {
            Set set = EnchantmentTypes.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"values(...)");
            Object object3 = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"first(...)");
            enchantmentType = (EnchantmentType)object3;
        } else {
            enchantmentType = object2;
        }
        this.type = enchantmentType;
        object2 = (EnchantmentRarity)EnchantmentRarities.INSTANCE.get(this.getPlugin().getVanillaEnchantsYml().getString(this.getEnchantment().getKey().getKey() + ".rarity"));
        if (object2 == null) {
            Set set = EnchantmentRarities.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"values(...)");
            Object object4 = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"first(...)");
            object = (EnchantmentRarity)object4;
        } else {
            object = object2;
        }
        this.enchantmentRarity = object;
        String string = this.getPlugin().getVanillaEnchantsYml().getString(this.getEnchantment().getKey().getKey() + ".name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.rawDisplayName = string;
    }

    @Override
    @NotNull
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    @NotNull
    public EcoEnchantsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public int getMaximumLevel() {
        return this.getEnchantment().getMaxLevel();
    }

    @Override
    @NotNull
    public EnchantmentType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public EnchantmentRarity getEnchantmentRarity() {
        return this.enchantmentRarity;
    }

    @Override
    @NotNull
    public String getRawDisplayName() {
        return this.rawDisplayName;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof VanillaEcoEnchantLike)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getEnchantment(), (Object)((VanillaEcoEnchantLike)other).getEnchantment());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getEnchantment()};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean canEnchantItem(@NotNull ItemStack item) {
        return EcoEnchantLike.DefaultImpls.canEnchantItem(this, item);
    }

    @Override
    @NotNull
    public String getRawDescription(int level, @Nullable Player player) {
        return EcoEnchantLike.DefaultImpls.getRawDescription(this, level, player);
    }
}

