/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.mechanics;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.ecoenchants.enchant.UtilKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/ecoenchants/mechanics/GrindstoneSupport;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "onGrindstone", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "core-plugin"})
public final class GrindstoneSupport
implements Listener {
    @NotNull
    private final EcoPlugin plugin;

    public GrindstoneSupport(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onGrindstone(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Inventory inventory = event.getView().getTopInventory();
        GrindstoneInventory grindstoneInventory = inventory instanceof GrindstoneInventory ? (GrindstoneInventory)inventory : null;
        if (grindstoneInventory == null) {
            return;
        }
        GrindstoneInventory inventory2 = grindstoneInventory;
        this.plugin.getScheduler().run(() -> GrindstoneSupport.onGrindstone$lambda$0(inventory2, event));
    }

    private static final void onGrindstone$lambda$0(GrindstoneInventory $inventory, InventoryClickEvent $event) {
        Integer level;
        Enchantment enchant;
        Map bottomEnchants;
        Map map;
        ItemStack itemStack;
        Map topEnchants;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)$inventory, (String)"$inventory");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        ItemStack itemStack2 = $inventory.getItem(0);
        if ((itemStack2 != null && (itemStack2 = FastItemStackExtensions.fast((ItemStack)itemStack2)) != null ? itemStack2.getEnchants(true) : (map2 = null)) == null) {
            map2 = topEnchants = MapsKt.emptyMap();
        }
        if (((itemStack = $inventory.getItem(1)) != null && (itemStack = FastItemStackExtensions.fast((ItemStack)itemStack)) != null ? itemStack.getEnchants(true) : (map = null)) == null) {
            map = bottomEnchants = MapsKt.emptyMap();
        }
        if (topEnchants.isEmpty() && bottomEnchants.isEmpty()) {
            return;
        }
        Map toKeep = new LinkedHashMap();
        for (Map.Entry entry : topEnchants.entrySet()) {
            enchant = (Enchantment)entry.getKey();
            level = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)enchant);
            if (!UtilKt.wrap(enchant).getType().getNoGrindstone()) continue;
            Intrinsics.checkNotNull((Object)level);
            toKeep.put(enchant, level);
        }
        for (Map.Entry entry : bottomEnchants.entrySet()) {
            enchant = (Enchantment)entry.getKey();
            level = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)enchant);
            if (!UtilKt.wrap(enchant).getType().getNoGrindstone()) continue;
            Integer n = (Integer)toKeep.get(enchant);
            int current = n != null ? n : 0;
            Intrinsics.checkNotNull((Object)level);
            toKeep.put(enchant, Math.max(level, current));
        }
        ItemStack result = $inventory.getItem(2);
        if (result == null || $event.isCancelled()) {
            return;
        }
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        if (toKeep.isEmpty()) {
            return;
        }
        if (meta instanceof EnchantmentStorageMeta) {
            Map map3 = ((EnchantmentStorageMeta)meta).getStoredEnchants();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getStoredEnchants(...)");
            var7_7 = MapsKt.toMap((Map)map3).entrySet().iterator();
            while (var7_7.hasNext()) {
                Enchantment enchant2 = (Enchantment)var7_7.next().getKey();
                ((EnchantmentStorageMeta)meta).removeStoredEnchant(enchant2);
            }
            for (Map.Entry entry : toKeep.entrySet()) {
                Enchantment enchant3 = (Enchantment)entry.getKey();
                int level2 = ((Number)entry.getValue()).intValue();
                ((EnchantmentStorageMeta)meta).addStoredEnchant(enchant3, level2, true);
            }
        } else {
            Map map4 = meta.getEnchants();
            Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getEnchants(...)");
            var7_7 = MapsKt.toMap((Map)map4).entrySet().iterator();
            while (var7_7.hasNext()) {
                Enchantment enchant4 = (Enchantment)var7_7.next().getKey();
                meta.removeEnchant(enchant4);
            }
            for (Map.Entry entry : toKeep.entrySet()) {
                Enchantment enchant5 = (Enchantment)entry.getKey();
                int level3 = ((Number)entry.getValue()).intValue();
                meta.addEnchant(enchant5, level3, true);
            }
        }
        result.setItemMeta(meta);
    }
}

