/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.ItemUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class WolfEntity
extends TameableEntity {
    private static final Set<Item> WOLF_FOODS = Set.of(Items.PUFFERFISH, Items.TROPICAL_FISH, Items.CHICKEN, Items.COOKED_CHICKEN, Items.PORKCHOP, Items.BEEF, Items.RABBIT, Items.COOKED_PORKCHOP, Items.COOKED_BEEF, Items.ROTTEN_FLESH, Items.MUTTON, Items.COOKED_MUTTON, Items.COOKED_RABBIT);
    private byte collarColor = (byte)14;
    private boolean isCurseOfBinding = false;

    public WolfEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void setTameableFlags(ByteEntityMetadata entityMetadata) {
        super.setTameableFlags(entityMetadata);
        if (this.getFlag(EntityFlag.ANGRY)) {
            this.dirtyMetadata.put(EntityDataTypes.COLOR, (byte)0);
        } else if (this.getFlag(EntityFlag.TAMED)) {
            this.updateCollarColor();
            UpdateAttributesPacket packet = new UpdateAttributesPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.setAttributes(Collections.singletonList(this.createHealthAttribute()));
            this.session.sendUpstreamPacket(packet);
        }
    }

    public void setCollarColor(IntEntityMetadata entityMetadata) {
        this.collarColor = (byte)entityMetadata.getPrimitiveValue();
        if (!this.getFlag(EntityFlag.ANGRY) && this.getFlag(EntityFlag.TAMED)) {
            this.updateCollarColor();
        }
    }

    private void updateCollarColor() {
        this.dirtyMetadata.put(EntityDataTypes.COLOR, this.collarColor);
        if (this.ownerBedrockId == 0L) {
            this.dirtyMetadata.put(EntityDataTypes.OWNER_EID, this.session.getPlayerEntity().getGeyserId());
        }
    }

    public void setWolfAngerTime(IntEntityMetadata entityMetadata) {
        int time = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ANGRY, time != 0);
        this.dirtyMetadata.put(EntityDataTypes.COLOR, time != 0 ? (byte)0 : this.collarColor);
    }

    public void setWolfVariant(IntEntityMetadata entityMetadata) {
        WolfVariant wolfVariant = this.session.getRegistryCache().wolfVariants().byId(entityMetadata.getPrimitiveValue());
        if (wolfVariant == null) {
            wolfVariant = WolfVariant.PALE;
        }
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, wolfVariant.ordinal());
    }

    @Override
    protected @Nullable ItemTag getFoodTag() {
        return ItemTag.WOLF_FOOD;
    }

    @Override
    public void setChestplate(ItemStack stack) {
        super.setChestplate(stack);
        this.isCurseOfBinding = ItemUtils.getEnchantmentLevel(stack.getDataComponents(), Enchantment.JavaEnchantment.BINDING_CURSE) > 0;
    }

    @Override
    protected boolean canBeLeashed() {
        return !this.getFlag(EntityFlag.ANGRY) && super.canBeLeashed();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.ANGRY)) {
            return InteractiveTag.NONE;
        }
        if (itemInHand.asItem() == Items.BONE && !this.getFlag(EntityFlag.TAMED)) {
            return InteractiveTag.TAME;
        }
        if (this.getFlag(EntityFlag.TAMED) && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            Item item = itemInHand.asItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (dyeItem.dyeColor() != this.collarColor) {
                    return InteractiveTag.DYE;
                }
                return super.testMobInteraction(hand, itemInHand);
            }
            if (itemInHand.asItem() == Items.WOLF_ARMOR && !this.chestplate.isValid() && !this.getFlag(EntityFlag.BABY)) {
                return InteractiveTag.EQUIP_WOLF_ARMOR;
            }
            if (itemInHand.asItem() == Items.SHEARS && this.chestplate.isValid() && (!this.isCurseOfBinding || this.session.getGameMode().equals(GameMode.CREATIVE))) {
                return InteractiveTag.REMOVE_WOLF_ARMOR;
            }
            if (Items.WOLF_ARMOR.isValidRepairItem(itemInHand.asItem()) && this.getFlag(EntityFlag.SITTING) && this.chestplate.isValid() && this.chestplate.getTag() != null && this.chestplate.getTag().getInt("Damage") > 0) {
                return InteractiveTag.REPAIR_WOLF_ARMOR;
            }
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId() || this.getFlag(EntityFlag.TAMED) || itemInHand.asItem() == Items.BONE && !this.getFlag(EntityFlag.ANGRY)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static enum WolfVariant {
        PALE,
        ASHEN,
        BLACK,
        CHESTNUT,
        RUSTY,
        SNOWY,
        SPOTTED,
        STRIPED,
        WOODS;

        private static final WolfVariant[] VALUES;
        private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ROOT);

        public static @Nullable WolfVariant getByJavaIdentifier(String javaIdentifier) {
            for (WolfVariant wolfVariant : VALUES) {
                if (!wolfVariant.javaIdentifier.equals(javaIdentifier)) continue;
                return wolfVariant;
            }
            return null;
        }

        static {
            VALUES = WolfVariant.values();
        }
    }
}

