/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.unix.PreferredDirectByteBufAllocator;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.network.netty.LocalChannelWithRemoteAddress;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.codec.PacketCodecHelper;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;
import org.geysermc.mcprotocollib.network.tcp.TcpPacketCodec;
import org.geysermc.mcprotocollib.network.tcp.TcpPacketSizer;
import org.geysermc.mcprotocollib.network.tcp.TcpSession;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;

public final class LocalSession
extends TcpSession {
    private static DefaultEventLoopGroup DEFAULT_EVENT_LOOP_GROUP;
    private static PreferredDirectByteBufAllocator PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR;
    private final SocketAddress targetAddress;
    private final String clientIp;
    private final PacketCodecHelper codecHelper;

    public LocalSession(String host, int port, SocketAddress targetAddress, String clientIp, PacketProtocol protocol, MinecraftCodecHelper codecHelper) {
        super(host, port, protocol);
        this.targetAddress = targetAddress;
        this.clientIp = clientIp;
        this.codecHelper = codecHelper;
    }

    @Override
    public void connect(boolean wait, final boolean transferring) {
        if (this.disconnected) {
            throw new IllegalStateException("Connection has already been disconnected.");
        }
        if (DEFAULT_EVENT_LOOP_GROUP == null) {
            DEFAULT_EVENT_LOOP_GROUP = new DefaultEventLoopGroup((ThreadFactory)new DefaultThreadFactory(this.getClass(), true));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> DEFAULT_EVENT_LOOP_GROUP.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS)));
        }
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.channel(LocalChannelWithRemoteAddress.class);
            ((Bootstrap)((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInitializer<LocalChannelWithRemoteAddress>(){

                public void initChannel(@NonNull LocalChannelWithRemoteAddress channel) {
                    channel.spoofedRemoteAddress(new InetSocketAddress(LocalSession.this.clientIp, 0));
                    PacketProtocol protocol = LocalSession.this.getPacketProtocol();
                    protocol.newClientSession(LocalSession.this, transferring);
                    LocalSession.this.refreshReadTimeoutHandler((Channel)channel);
                    LocalSession.this.refreshWriteTimeoutHandler((Channel)channel);
                    ChannelPipeline pipeline = channel.pipeline();
                    pipeline.addLast("sizer", (ChannelHandler)new TcpPacketSizer(LocalSession.this, protocol.getPacketHeader().getLengthSize()));
                    pipeline.addLast("codec", (ChannelHandler)new TcpPacketCodec(LocalSession.this, true));
                    pipeline.addLast("manager", (ChannelHandler)LocalSession.this);
                    LocalSession.this.addHAProxySupport(pipeline);
                }
            })).group((EventLoopGroup)DEFAULT_EVENT_LOOP_GROUP)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(this.getConnectTimeout() * 1000));
            if (PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR != null) {
                bootstrap.option(ChannelOption.ALLOCATOR, (Object)PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR);
            }
            bootstrap.remoteAddress(this.targetAddress);
            bootstrap.connect().addListener(future -> {
                if (!future.isSuccess()) {
                    this.exceptionCaught(null, future.cause());
                }
            });
        }
        catch (Throwable t) {
            this.exceptionCaught(null, t);
        }
    }

    @Override
    public MinecraftCodecHelper getCodecHelper() {
        return (MinecraftCodecHelper)this.codecHelper;
    }

    private void addHAProxySupport(ChannelPipeline pipeline) {
        final InetSocketAddress clientAddress = this.getFlag(BuiltinFlags.CLIENT_PROXIED_ADDRESS);
        if (this.getFlag(BuiltinFlags.ENABLE_CLIENT_PROXY_PROTOCOL, false).booleanValue() && clientAddress != null) {
            pipeline.addFirst("proxy-protocol-packet-sender", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(@NonNull ChannelHandlerContext ctx) throws Exception {
                    HAProxyProxiedProtocol proxiedProtocol = clientAddress.getAddress() instanceof Inet4Address ? HAProxyProxiedProtocol.TCP4 : HAProxyProxiedProtocol.TCP6;
                    InetSocketAddress remoteAddress = ctx.channel().remoteAddress() instanceof InetSocketAddress ? (InetSocketAddress)ctx.channel().remoteAddress() : new InetSocketAddress(LocalSession.this.host, LocalSession.this.port);
                    ctx.channel().writeAndFlush((Object)new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, proxiedProtocol, clientAddress.getAddress().getHostAddress(), remoteAddress.getAddress().getHostAddress(), clientAddress.getPort(), remoteAddress.getPort()));
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.pipeline().remove("proxy-protocol-encoder");
                    super.channelActive(ctx);
                }
            });
            pipeline.addFirst("proxy-protocol-encoder", (ChannelHandler)HAProxyMessageEncoder.INSTANCE);
        }
    }

    public static void createDirectByteBufAllocator() {
        if (PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR == null) {
            PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR = new PreferredDirectByteBufAllocator();
            PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR.updateAllocator(ByteBufAllocator.DEFAULT);
        }
    }

    static {
        PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR = null;
    }
}

