/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandExecutor;
import org.geysermc.geyser.platform.spigot.command.SpigotCommandSource;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserSpigotCommandExecutor
extends GeyserCommandExecutor
implements TabExecutor {
    public GeyserSpigotCommandExecutor(GeyserImpl geyser, Map<String, Command> commands) {
        super(geyser, commands);
    }

    public boolean onCommand(@NonNull CommandSender sender, @NonNull org.bukkit.command.Command command, @NonNull String label, String[] args) {
        SpigotCommandSource commandSender = new SpigotCommandSource(sender);
        GeyserSession session = this.getGeyserSession(commandSender);
        if (args.length > 0) {
            GeyserCommand geyserCommand = this.getCommand(args[0]);
            if (geyserCommand != null) {
                if (!sender.hasPermission(geyserCommand.permission())) {
                    String message = GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.permission_fail", commandSender.locale());
                    commandSender.sendMessage(ChatColor.RED + message);
                    return true;
                }
                if (geyserCommand.isBedrockOnly() && session == null) {
                    sender.sendMessage(ChatColor.RED + GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.bedrock_only", commandSender.locale()));
                    return true;
                }
                geyserCommand.execute(session, commandSender, args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
                return true;
            }
        } else {
            this.getCommand("help").execute(session, commandSender, new String[0]);
            return true;
        }
        String message = GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.not_found", commandSender.locale());
        commandSender.sendMessage(ChatColor.RED + message);
        return true;
    }

    public List<String> onTabComplete(@NonNull CommandSender sender, @NonNull org.bukkit.command.Command command, @NonNull String label, String[] args) {
        if (args.length == 1) {
            return this.tabComplete(new SpigotCommandSource(sender));
        }
        return Collections.emptyList();
    }
}

