/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BedrockOnlyBlockEntity;
import org.geysermc.geyser.util.BlockEntityUtils;

public class FlowerPotBlockEntityTranslator
implements BedrockOnlyBlockEntity {
    public static boolean isFlowerBlock(int blockState) {
        return BlockStateValues.getFlowerPotValues().containsKey(blockState);
    }

    public static NbtMap getTag(GeyserSession session, int blockState, Vector3i position) {
        NbtMap plant;
        NbtMapBuilder tagBuilder = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putByte("isMovable", (byte)1).putString("id", "FlowerPot");
        String name = (String)BlockStateValues.getFlowerPotValues().get(blockState);
        if (name != null && (plant = session.getBlockMappings().getFlowerPotBlocks().get(name)) != null) {
            tagBuilder.put("PlantBlock", (Object)plant.toBuilder().build());
        }
        return tagBuilder.build();
    }

    @Override
    public boolean isBlock(int blockState) {
        return FlowerPotBlockEntityTranslator.isFlowerBlock(blockState);
    }

    @Override
    public void updateBlock(GeyserSession session, int blockState, Vector3i position) {
        NbtMap tag = FlowerPotBlockEntityTranslator.getTag(session, blockState, position);
        BlockEntityUtils.updateBlockEntity(session, tag, position);
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setDefinition(session.getBlockMappings().getBedrockBlock(blockState));
        updateBlockPacket.setBlockPosition(position);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.PRIORITY);
        session.sendUpstreamPacket(updateBlockPacket);
        BlockEntityUtils.updateBlockEntity(session, tag, position);
    }
}

