/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.scoreboard.JavaSetScoreTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard.ClientboundResetScorePacket;

@Translator(packet=ClientboundResetScorePacket.class)
public class JavaResetScorePacket
extends PacketTranslator<ClientboundResetScorePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundResetScorePacket packet) {
        WorldCache worldCache = session.getWorldCache();
        Scoreboard scoreboard = worldCache.getScoreboard();
        int pps = worldCache.increaseAndGetScoreboardPacketsPerSecond();
        Objective belowName = scoreboard.getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME);
        if (packet.getObjective() == null) {
            for (Objective otherObjective : scoreboard.getObjectives()) {
                otherObjective.removeScore(packet.getOwner());
            }
            if (belowName != null) {
                JavaSetScoreTranslator.setBelowName(session, belowName, packet.getOwner());
            }
        } else {
            Objective objective = scoreboard.getObjective(packet.getObjective());
            objective.removeScore(packet.getOwner());
            if (objective == belowName) {
                JavaSetScoreTranslator.setBelowName(session, objective, packet.getOwner());
            }
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }
}

