/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public class Instrument {
    private final Sound soundEvent;
    private final int useDuration;
    private final float range;

    public Sound getSoundEvent() {
        return this.soundEvent;
    }

    public int getUseDuration() {
        return this.useDuration;
    }

    public float getRange() {
        return this.range;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instrument)) {
            return false;
        }
        Instrument other = (Instrument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUseDuration() != other.getUseDuration()) {
            return false;
        }
        if (Float.compare(this.getRange(), other.getRange()) != 0) {
            return false;
        }
        Sound this$soundEvent = this.getSoundEvent();
        Sound other$soundEvent = other.getSoundEvent();
        return !(this$soundEvent == null ? other$soundEvent != null : !this$soundEvent.equals(other$soundEvent));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Instrument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUseDuration();
        result = result * 59 + Float.floatToIntBits(this.getRange());
        Sound $soundEvent = this.getSoundEvent();
        result = result * 59 + ($soundEvent == null ? 43 : $soundEvent.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "Instrument(soundEvent=" + this.getSoundEvent() + ", useDuration=" + this.getUseDuration() + ", range=" + this.getRange() + ")";
    }

    public Instrument(Sound soundEvent, int useDuration, float range) {
        this.soundEvent = soundEvent;
        this.useDuration = useDuration;
        this.range = range;
    }
}

