/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;

public class ToolData {
    private final List<Rule> rules;
    private final float defaultMiningSpeed;
    private final int damagePerBlock;

    public List<Rule> getRules() {
        return this.rules;
    }

    public float getDefaultMiningSpeed() {
        return this.defaultMiningSpeed;
    }

    public int getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolData)) {
            return false;
        }
        ToolData other = (ToolData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getDefaultMiningSpeed(), other.getDefaultMiningSpeed()) != 0) {
            return false;
        }
        if (this.getDamagePerBlock() != other.getDamagePerBlock()) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ToolData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDefaultMiningSpeed());
        result = result * 59 + this.getDamagePerBlock();
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ToolData(rules=" + this.getRules() + ", defaultMiningSpeed=" + this.getDefaultMiningSpeed() + ", damagePerBlock=" + this.getDamagePerBlock() + ")";
    }

    public ToolData(List<Rule> rules, float defaultMiningSpeed, int damagePerBlock) {
        this.rules = rules;
        this.defaultMiningSpeed = defaultMiningSpeed;
        this.damagePerBlock = damagePerBlock;
    }

    public static class Rule {
        @Nullable
        private final String location;
        private final int @Nullable [] holders;
        @Nullable
        private final Float speed;
        @Nullable
        private final Boolean correctForDrops;

        @Nullable
        public String getLocation() {
            return this.location;
        }

        public int @Nullable [] getHolders() {
            return this.holders;
        }

        @Nullable
        public Float getSpeed() {
            return this.speed;
        }

        @Nullable
        public Boolean getCorrectForDrops() {
            return this.correctForDrops;
        }

        public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rule)) {
                return false;
            }
            Rule other = (Rule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$speed = this.getSpeed();
            Float other$speed = other.getSpeed();
            if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
                return false;
            }
            Boolean this$correctForDrops = this.getCorrectForDrops();
            Boolean other$correctForDrops = other.getCorrectForDrops();
            if (this$correctForDrops == null ? other$correctForDrops != null : !((Object)this$correctForDrops).equals(other$correctForDrops)) {
                return false;
            }
            String this$location = this.getLocation();
            String other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            return Arrays.equals(this.getHolders(), other.getHolders());
        }

        protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
            return other instanceof Rule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $speed = this.getSpeed();
            result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
            Boolean $correctForDrops = this.getCorrectForDrops();
            result = result * 59 + ($correctForDrops == null ? 43 : ((Object)$correctForDrops).hashCode());
            String $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            result = result * 59 + Arrays.hashCode(this.getHolders());
            return result;
        }

        public @NonNull String toString() {
            return "ToolData.Rule(location=" + this.getLocation() + ", holders=" + Arrays.toString(this.getHolders()) + ", speed=" + this.getSpeed() + ", correctForDrops=" + this.getCorrectForDrops() + ")";
        }

        public Rule(@Nullable String location, int @Nullable [] holders, @Nullable Float speed, @Nullable Boolean correctForDrops) {
            this.location = location;
            this.holders = holders;
            this.speed = speed;
            this.correctForDrops = correctForDrops;
        }
    }
}

