/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetCameraPacket
implements MinecraftPacket {
    private final int cameraEntityId;

    public ClientboundSetCameraPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.cameraEntityId = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.cameraEntityId);
    }

    public int getCameraEntityId() {
        return this.cameraEntityId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetCameraPacket)) {
            return false;
        }
        ClientboundSetCameraPacket other = (ClientboundSetCameraPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getCameraEntityId() == other.getCameraEntityId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetCameraPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCameraEntityId();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetCameraPacket(cameraEntityId=" + this.getCameraEntityId() + ")";
    }

    public @NonNull ClientboundSetCameraPacket withCameraEntityId(int cameraEntityId) {
        return this.cameraEntityId == cameraEntityId ? this : new ClientboundSetCameraPacket(cameraEntityId);
    }

    public ClientboundSetCameraPacket(int cameraEntityId) {
        this.cameraEntityId = cameraEntityId;
    }
}

