/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundHurtAnimationPacket
implements MinecraftPacket {
    private final int id;
    private final float yaw;

    public ClientboundHurtAnimationPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.id = helper.readVarInt(in);
        this.yaw = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.id);
        out.writeFloat(this.yaw);
    }

    public int getId() {
        return this.id;
    }

    public float getYaw() {
        return this.yaw;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundHurtAnimationPacket)) {
            return false;
        }
        ClientboundHurtAnimationPacket other = (ClientboundHurtAnimationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return Float.compare(this.getYaw(), other.getYaw()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundHurtAnimationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundHurtAnimationPacket(id=" + this.getId() + ", yaw=" + this.getYaw() + ")";
    }

    public @NonNull ClientboundHurtAnimationPacket withId(int id) {
        return this.id == id ? this : new ClientboundHurtAnimationPacket(id, this.yaw);
    }

    public @NonNull ClientboundHurtAnimationPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundHurtAnimationPacket(this.id, yaw);
    }

    public ClientboundHurtAnimationPacket(int id, float yaw) {
        this.id = id;
        this.yaw = yaw;
    }
}

