/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundRemoveEntitiesPacket
implements MinecraftPacket {
    private final int @lombok.NonNull [] entityIds;

    public ClientboundRemoveEntitiesPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entityIds = new int[helper.readVarInt(in)];
        for (int i = 0; i < this.entityIds.length; ++i) {
            this.entityIds[i] = helper.readVarInt(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.entityIds.length);
        for (int entityId : this.entityIds) {
            helper.writeVarInt(out, entityId);
        }
    }

    public int @lombok.NonNull [] getEntityIds() {
        return this.entityIds;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRemoveEntitiesPacket)) {
            return false;
        }
        ClientboundRemoveEntitiesPacket other = (ClientboundRemoveEntitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getEntityIds(), other.getEntityIds());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRemoveEntitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getEntityIds());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRemoveEntitiesPacket(entityIds=" + Arrays.toString(this.getEntityIds()) + ")";
    }

    public @NonNull ClientboundRemoveEntitiesPacket withEntityIds(int @lombok.NonNull [] entityIds) {
        if (entityIds == null) {
            throw new NullPointerException("entityIds is marked non-null but is null");
        }
        return this.entityIds == entityIds ? this : new ClientboundRemoveEntitiesPacket(entityIds);
    }

    public ClientboundRemoveEntitiesPacket(int @lombok.NonNull [] entityIds) {
        if (entityIds == null) {
            throw new NullPointerException("entityIds is marked non-null but is null");
        }
        this.entityIds = entityIds;
    }
}

