/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;

public class ClientboundSetEntityDataPacket
implements MinecraftPacket {
    private final int entityId;
    @lombok.NonNull
    private final EntityMetadata<?, ?>[] metadata;

    public ClientboundSetEntityDataPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entityId = helper.readVarInt(in);
        this.metadata = helper.readEntityMetadata(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.entityId);
        helper.writeEntityMetadata(out, this.metadata);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public EntityMetadata<?, ?>[] getMetadata() {
        return this.metadata;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEntityDataPacket)) {
            return false;
        }
        ClientboundSetEntityDataPacket other = (ClientboundSetEntityDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.deepEquals(this.getMetadata(), other.getMetadata());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetEntityDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.deepHashCode(this.getMetadata());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetEntityDataPacket(entityId=" + this.getEntityId() + ", metadata=" + Arrays.deepToString(this.getMetadata()) + ")";
    }

    public @NonNull ClientboundSetEntityDataPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEntityDataPacket(entityId, this.metadata);
    }

    public @NonNull ClientboundSetEntityDataPacket withMetadata(@lombok.NonNull EntityMetadata<?, ?>[] metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.metadata == metadata ? this : new ClientboundSetEntityDataPacket(this.entityId, metadata);
    }

    public ClientboundSetEntityDataPacket(int entityId, @lombok.NonNull EntityMetadata<?, ?>[] metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.entityId = entityId;
        this.metadata = metadata;
    }
}

