/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundChatPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String message;
    private final long timeStamp;
    private final long salt;
    private final byte @Nullable [] signature;
    private final int offset;
    private final BitSet acknowledgedMessages;

    public ServerboundChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.message = helper.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        if (in.readBoolean()) {
            this.signature = new byte[256];
            in.readBytes(this.signature);
        } else {
            this.signature = null;
        }
        this.offset = helper.readVarInt(in);
        this.acknowledgedMessages = helper.readFixedBitSet(in, 20);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.message);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        out.writeBoolean(this.signature != null);
        if (this.signature != null) {
            out.writeBytes(this.signature);
        }
        helper.writeVarInt(out, this.offset);
        helper.writeFixedBitSet(out, this.acknowledgedMessages, 20);
    }

    @lombok.NonNull
    public String getMessage() {
        return this.message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public byte @Nullable [] getSignature() {
        return this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSet getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatPacket)) {
            return false;
        }
        ServerboundChatPacket other = (ServerboundChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        BitSet this$acknowledgedMessages = this.getAcknowledgedMessages();
        BitSet other$acknowledgedMessages = other.getAcknowledgedMessages();
        return !(this$acknowledgedMessages == null ? other$acknowledgedMessages != null : !((Object)this$acknowledgedMessages).equals(other$acknowledgedMessages));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + this.getOffset();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        BitSet $acknowledgedMessages = this.getAcknowledgedMessages();
        result = result * 59 + ($acknowledgedMessages == null ? 43 : ((Object)$acknowledgedMessages).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundChatPacket(message=" + this.getMessage() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signature=" + Arrays.toString(this.getSignature()) + ", offset=" + this.getOffset() + ", acknowledgedMessages=" + this.getAcknowledgedMessages() + ")";
    }

    public @NonNull ServerboundChatPacket withMessage(@lombok.NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.message == message ? this : new ServerboundChatPacket(message, this.timeStamp, this.salt, this.signature, this.offset, this.acknowledgedMessages);
    }

    public @NonNull ServerboundChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatPacket(this.message, timeStamp, this.salt, this.signature, this.offset, this.acknowledgedMessages);
    }

    public @NonNull ServerboundChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatPacket(this.message, this.timeStamp, salt, this.signature, this.offset, this.acknowledgedMessages);
    }

    public @NonNull ServerboundChatPacket withSignature(byte @Nullable [] signature) {
        return this.signature == signature ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, signature, this.offset, this.acknowledgedMessages);
    }

    public @NonNull ServerboundChatPacket withOffset(int offset) {
        return this.offset == offset ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, offset, this.acknowledgedMessages);
    }

    public @NonNull ServerboundChatPacket withAcknowledgedMessages(BitSet acknowledgedMessages) {
        return this.acknowledgedMessages == acknowledgedMessages ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, this.offset, acknowledgedMessages);
    }

    public ServerboundChatPacket(@lombok.NonNull String message, long timeStamp, long salt, byte @Nullable [] signature, int offset, BitSet acknowledgedMessages) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signature = signature;
        this.offset = offset;
        this.acknowledgedMessages = acknowledgedMessages;
    }
}

