/*
 * Decompiled with CFR 0.152.
 */
package com.pa_project.lib.json;

import com.pa_project.lib.json.JSONArray;
import com.pa_project.lib.json.JSONAware;
import com.pa_project.lib.json.JSONSection;
import com.pa_project.lib.json.JSONStreamAware;
import com.pa_project.lib.json.JSONStringUtil;
import com.pa_project.lib.json.JSONValue;
import com.pa_project.lib.json.parser.JSONParseException;
import com.pa_project.lib.json.parser.JSONParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSONObject
extends HashMap
implements JSONAware,
JSONStreamAware,
Map {
    public void setJSONValue(String string, Object object) {
        JSONObject jSONObject = this;
        String string2 = null;
        if (string.contains(".")) {
            String[] stringArray = string.split("\\.", -1);
            for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                String string3 = stringArray[i2];
                string2 = stringArray[i2 + 1];
                if (jSONObject.getJSONObject(string3) == null) {
                    jSONObject.put(string3, new JSONObject());
                }
                jSONObject = jSONObject.getJSONObject(string3);
            }
        } else {
            string2 = string;
        }
        if (object == null) {
            jSONObject.remove(string2);
        } else {
            jSONObject.put(string2, object);
        }
    }

    public int getInt(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isInteger(jSONObject.get(string).toString()) ? Integer.parseInt(jSONObject.get(string).toString()) : 0;
        }
        return this.get(object) != null && JSONObject.isInteger(this.get(object).toString()) ? Integer.parseInt(this.get(object).toString()) : 0;
    }

    public boolean getBoolean(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null ? Boolean.valueOf(jSONObject.get(string).toString()) : false;
        }
        return this.get(object) != null ? Boolean.valueOf(this.get(object).toString()) : false;
    }

    public Object getObject(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            String string = jSONSection.getSectionName();
            return jSONObject.get(string);
        }
        return this.get(object);
    }

    public String getString(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null ? jSONObject.get(string).toString() : null;
        }
        return this.get(object) != null ? this.get(object).toString() : null;
    }

    public Integer getInteger(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isInteger(jSONObject.get(string).toString()) ? Integer.valueOf(Integer.parseInt(jSONObject.get(string).toString())) : null;
        }
        return this.get(object) != null && JSONObject.isInteger(this.get(object).toString()) ? Integer.valueOf(Integer.parseInt(this.get(object).toString())) : null;
    }

    public Double getDouble(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isDouble(jSONObject.get(string).toString()) ? Double.valueOf(jSONObject.get(string).toString()) : null;
        }
        return this.get(object) != null && JSONObject.isDouble(this.get(object).toString()) ? Double.valueOf(this.get(object).toString()) : null;
    }

    public Long getLong(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isLong(jSONObject.get(string).toString()) ? Long.valueOf(jSONObject.get(string).toString()) : null;
        }
        return this.get(object) != null && JSONObject.isLong(this.get(object).toString()) ? Long.valueOf(this.get(object).toString()) : null;
    }

    public Short getShort(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isShort(jSONObject.get(string).toString()) ? Short.valueOf(jSONObject.get(string).toString()) : null;
        }
        return this.get(object) != null && JSONObject.isShort(this.get(object).toString()) ? Short.valueOf(this.get(object).toString()) : null;
    }

    public Float getFloat(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isFloat(jSONObject.get(string).toString()) ? Float.valueOf(jSONObject.get(string).toString()) : null;
        }
        return this.get(object) != null && JSONObject.isFloat(this.get(object).toString()) ? Float.valueOf(this.get(object).toString()) : null;
    }

    public Byte getByte(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && JSONObject.isByte(jSONObject.get(string).toString()) ? Byte.valueOf(jSONObject.get(string).toString()) : null;
        }
        return this.get(object) != null && JSONObject.isByte(this.get(object).toString()) ? Byte.valueOf(this.get(object).toString()) : null;
    }

    public Set getSet(Object object2) {
        HashSet hashSet = new HashSet();
        this.getRawSet(object2).stream().forEach((? super T object) -> hashSet.add(object));
        return hashSet;
    }

    public Set getRawSet(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && jSONObject.get(string) instanceof Set ? (Set)jSONObject.get(string) : new HashSet();
        }
        return this.get(object) != null && this.get(object) instanceof Set ? (Set)this.get(object) : new HashSet();
    }

    public List getList(Object object2) {
        ArrayList arrayList = new ArrayList();
        this.getRawList(object2).stream().forEach((? super T object) -> arrayList.add(object));
        return arrayList;
    }

    public List getRawList(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && jSONObject.get(string) instanceof List ? (List)jSONObject.get(string) : new ArrayList();
        }
        return this.get(object) != null && this.get(object) instanceof List ? (List)this.get(object) : new ArrayList();
    }

    public Set getStringSet(Object object2) {
        HashSet hashSet = new HashSet();
        this.getRawSet(object2).stream().forEach((? super T object) -> hashSet.add(object.toString()));
        return hashSet;
    }

    public Set getIntegerSet(Object object2) {
        HashSet hashSet = new HashSet();
        this.getRawSet(object2).stream().filter(object -> JSONObject.isInteger(object.toString())).forEach((? super T object) -> hashSet.add(Integer.valueOf(object.toString())));
        return hashSet;
    }

    public List getStringList(Object object2) {
        ArrayList arrayList = new ArrayList();
        this.getRawList(object2).stream().forEach((? super T object) -> arrayList.add(object.toString()));
        return arrayList;
    }

    public List getIntegerList(Object object2) {
        ArrayList arrayList = new ArrayList();
        this.getRawList(object2).stream().filter(object -> JSONObject.isInteger(object.toString())).forEach((? super T object) -> arrayList.add(Integer.valueOf(object.toString())));
        return arrayList;
    }

    public JSONObject getJSONObject(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && jSONObject.get(string) instanceof JSONObject ? (JSONObject)jSONObject.get(string) : null;
        }
        return this.get(object) != null && this.get(object) instanceof JSONObject ? (JSONObject)this.get(object) : null;
    }

    public JSONArray getJSONArray(Object object) {
        if (object instanceof String && ((String)object).contains(".") && this.get(object) == null) {
            String string;
            JSONSection jSONSection = this.getJSONSection((String)object);
            JSONObject jSONObject = jSONSection.getJSONObject();
            return jSONObject.get(string = jSONSection.getSectionName()) != null && jSONObject.get(string) instanceof JSONArray ? (JSONArray)jSONObject.get(string) : null;
        }
        return this.get(object) != null && this.get(object) instanceof JSONArray ? (JSONArray)this.get(object) : null;
    }

    public JSONSection getJSONSection(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains(".")) {
            return new JSONSection(this, string);
        }
        HashMap hashMap = null;
        String string2 = null;
        String[] stringArray = string.split("\\.", -1);
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            String string3 = stringArray[i2];
            string2 = stringArray[i2 + 1];
            hashMap = hashMap != null ? (hashMap.get(string3) != null && hashMap.get(string3) instanceof JSONObject ? (JSONObject)hashMap.get(string3) : null) : (this.get(string3) != null && this.get(string3) instanceof JSONObject ? (JSONObject)this.get(string3) : null);
        }
        return new JSONSection((JSONObject)hashMap, string2);
    }

    public List getJSONSections() {
        return this.getJSONSections(this, null);
    }

    public List getJSONSections(JSONObject jSONObject, String string) {
        ArrayList arrayList = new ArrayList();
        if (jSONObject == null) {
            return arrayList;
        }
        jSONObject.keySet().stream().forEach((? super T object) -> {
            String string2;
            String string3 = string2 = string == null ? object.toString() : string + "." + object.toString();
            if (jSONObject.get(object) instanceof JSONObject) {
                arrayList.addAll(jSONObject.getJSONSections(jSONObject.getJSONObject(object), string2));
            } else {
                arrayList.add(new JSONSection(jSONObject, string2));
            }
        });
        return arrayList;
    }

    @Override
    public void writeJSONString(Writer writer) {
        JSONObject.writeJSONString(this, writer);
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

    @Override
    public String toJSONString(int n2) {
        return JSONStringUtil.toJSONString(this, n2);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public static void writeJSONString(Map map, Writer writer) {
        if (map == null) {
            writer.write("null");
            return;
        }
        boolean bl = true;
        Iterator iterator = map.entrySet().iterator();
        writer.write(123);
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                writer.write(44);
            }
            Map.Entry entry = iterator.next();
            writer.write(34);
            writer.write(JSONStringUtil.escape(String.valueOf(entry.getKey())));
            writer.write(34);
            writer.write(58);
            JSONValue.valueWriteJSONString(entry.getValue(), writer);
        }
        writer.write(125);
    }

    public static boolean isJSON(String string) {
        try {
            JSONObject.toJSONObject(string);
            return true;
        }
        catch (JSONParseException jSONParseException) {
            return false;
        }
    }

    public static String toJSONString(Map map) {
        return JSONStringUtil.toJSONString(map);
    }

    public static String toVisibleJSONString(Map map) {
        return JSONStringUtil.toJSONString(map, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject toJSONObject(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            for (int i2 = 0; i2 != byArray.length; i2 += ((InputStream)fileInputStream).read(byArray, i2, byArray.length - i2)) {
            }
            JSONObject jSONObject = JSONObject.toJSONObject(new String(byArray));
            return jSONObject;
        }
        catch (IOException iOException) {
            Logger.getLogger(JSONObject.class.getName()).log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    public static JSONObject toJSONObject(Map map) {
        if (map == null) {
            return new JSONObject();
        }
        String string = JSONObject.toJSONString(map);
        JSONParser jSONParser = new JSONParser();
        return jSONParser.a(string);
    }

    public static JSONObject toJSONObject(String string) {
        if (string == null) {
            return new JSONObject();
        }
        JSONParser jSONParser = new JSONParser();
        return jSONParser.a(string);
    }

    private static boolean isInteger(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isDouble(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isLong(String string) {
        try {
            Long.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isShort(String string) {
        try {
            Short.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isFloat(String string) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isByte(String string) {
        try {
            Byte.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

