/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.mailbox;

import com.pa_project.lib.json.JSONObject;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.trc.bukkit.globalmarketplus.api.a;
import studio.trc.bukkit.globalmarketplus.m.g;
import studio.trc.bukkit.globalmarketplus.m.h;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMailSort;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMailState;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMailType;
import studio.trc.bukkit.globalmarketplus.n.c;
import studio.trc.bukkit.globalmarketplus.n.d;

public class ItemMail
extends h
implements Serializable {
    private final long mailUID;
    private final long sendingTime;
    private final UUID ownerUUID;
    private final String ownerName;
    private final ItemStack item;
    private final ItemMailType mailType;
    private long expireTime = -1L;
    private boolean pickedUp = false;
    private UUID senderUUID = null;
    private String senderName = null;
    private ItemMailState itemMailState = ItemMailState.NORMAL;

    public ItemMail(long l2, UUID uUID, String string, ItemMailType itemMailType, long l3, long l4, ItemStack itemStack) {
        this.mailUID = l2;
        this.ownerUUID = uUID;
        this.ownerName = string;
        this.mailType = itemMailType;
        this.sendingTime = l3;
        this.expireTime = l4;
        this.item = itemStack;
    }

    public boolean isExpired() {
        return this.expireTime != -1L && System.currentTimeMillis() >= this.expireTime;
    }

    public int compareLevel() {
        if (!this.isExpired() && !this.isPickedUp()) {
            return 3;
        }
        if (this.isPickedUp()) {
            return 2;
        }
        if (this.isExpired()) {
            return 1;
        }
        return 0;
    }

    public int compareTo(ItemMail itemMail, ItemMailSort itemMailSort) {
        switch (itemMailSort.getName()) {
            case "ACCORDING_TO_THE_STATE": {
                return this.compareLevel() > itemMail.compareLevel() ? 1 : -1;
            }
            case "ACCORDING_TO_SENDING_TIME": {
                return this.sendingTime > itemMail.getSendingTime() ? 1 : -1;
            }
            case "ACCORDING_TO_EXPIRE_TIME": {
                return this.expireTime > itemMail.getExpireTime() ? 1 : -1;
            }
            case "ACCORDING_TO_ITEM_AMOUNT": {
                return this.item.getAmount() > itemMail.getItem().getAmount() ? 1 : -1;
            }
            case "RANDOM": {
                Random random = new Random();
                return random.nextInt(10) > random.nextInt(10) ? 1 : -1;
            }
        }
        return -1;
    }

    public JSONObject serialize() {
        return ItemMail.serialize(this);
    }

    @Override
    public int compareTo(h h2) {
        if (h2 instanceof ItemMail) {
            return this.compareTo((ItemMail)h2, ItemMailSort.getDefaultSort());
        }
        return -1;
    }

    @Override
    public int compareTo(h h2, g g2) {
        if (g2 instanceof ItemMailSort) {
            return this.compareTo((ItemMail)h2, (ItemMailSort)g2);
        }
        return -1;
    }

    public String toString() {
        return this.serialize().toJSONString();
    }

    public ItemStack pickUp(Player player) {
        if (player != null && player.getInventory().firstEmpty() != -1 && !this.isExpired() && !this.isPickedUp()) {
            studio.trc.bukkit.globalmarketplus.j.b.c c2;
            a a2;
            this.pickedUp = true;
            this.itemMailState = ItemMailState.PICKED_UP;
            if (a.c() && a.a(studio.trc.bukkit.globalmarketplus.j.c.MAIL_PICKUP_RECORD) && !(a2 = a.b()).a(c2 = new studio.trc.bukkit.globalmarketplus.j.b.c(System.currentTimeMillis(), player.getUniqueId(), player.getName(), this))) {
                Map map = studio.trc.bukkit.globalmarketplus.g.c.e();
                map.put("{record}", c2.k().toJSONString());
                c.a("CreateRecordFailed", map);
            }
            return new ItemStack(this.item);
        }
        return null;
    }

    public static JSONObject serialize(ItemMail itemMail) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("UID", itemMail.mailUID);
        jSONObject.put("OwnerUUID", itemMail.ownerUUID.toString());
        jSONObject.put("OwnerName", itemMail.ownerName);
        jSONObject.put("MailType", itemMail.mailType.name());
        jSONObject.put("SendingTime", itemMail.sendingTime);
        jSONObject.put("ExpireTime", itemMail.expireTime);
        jSONObject.put("Item", d.b(itemMail.item));
        if (itemMail.isPickedUp()) {
            jSONObject.put("PickedUp", true);
        }
        if (itemMail.senderUUID != null) {
            jSONObject.put("SenderUUID", itemMail.senderUUID.toString());
        }
        if (itemMail.senderName != null) {
            jSONObject.put("SenderName", itemMail.senderName);
        }
        if (!itemMail.itemMailState.equals((Object)ItemMailState.NORMAL)) {
            jSONObject.put("ItemMailState", itemMail.itemMailState.name());
        }
        return jSONObject;
    }

    public static ItemMail deserialize(JSONObject jSONObject) {
        try {
            ItemStack itemStack = d.l(jSONObject.getString("Item"));
            if (itemStack == null) {
                return null;
            }
            ItemMail itemMail = new ItemMail(jSONObject.getLong("UID"), UUID.fromString(jSONObject.getString("OwnerUUID")), jSONObject.getString("OwnerName"), ItemMailType.valueOf(jSONObject.getString("MailType")), jSONObject.getLong("SendingTime"), jSONObject.getLong("ExpireTime"), itemStack);
            if (jSONObject.containsKey("PickedUp")) {
                itemMail.setPickedUp(jSONObject.getBoolean("PickedUp"));
            }
            if (jSONObject.containsKey("SenderUUID")) {
                itemMail.setSenderUUID(UUID.fromString(jSONObject.getString("SenderUUID")));
            }
            if (jSONObject.containsKey("SenderName")) {
                itemMail.setSenderName(jSONObject.getString("SenderName"));
            }
            if (jSONObject.containsKey("ItemMailState")) {
                itemMail.setItemMailState(ItemMailState.valueOf(jSONObject.getString("ItemMailState")));
            }
            return itemMail;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public long getMailUID() {
        return this.mailUID;
    }

    public long getSendingTime() {
        return this.sendingTime;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemMailType getMailType() {
        return this.mailType;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public boolean isPickedUp() {
        return this.pickedUp;
    }

    public void setPickedUp(boolean bl) {
        this.pickedUp = bl;
    }

    public UUID getSenderUUID() {
        return this.senderUUID;
    }

    public void setSenderUUID(UUID uUID) {
        this.senderUUID = uUID;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String string) {
        this.senderName = string;
    }

    public ItemMailState getItemMailState() {
        return this.itemMailState;
    }

    public void setItemMailState(ItemMailState itemMailState) {
        this.itemMailState = itemMailState;
    }
}

