/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class ReflectionUtils {
    public static final String NMS_VERSION;
    public static final int MINOR_NUMBER;
    public static final int PATCH_NUMBER;
    public static final String CRAFTBUKKIT_PACKAGE;
    public static final String NMS_PACKAGE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle SEND_PACKET;

    public static String getVersionInformation() {
        return "(NMS: " + NMS_VERSION + " | Minecraft: " + Bukkit.getVersion() + " | Bukkit: " + Bukkit.getBukkitVersion() + ')';
    }

    public static Integer getLatestPatchNumberOf(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Minor version must be positive: " + n);
        }
        int[] nArray = new int[]{1, 5, 2, 7, 2, 4, 10, 8, 4, 2, 2, 2, 2, 4, 2, 5, 1, 2, 4, 0};
        if (n > nArray.length) {
            return null;
        }
        return nArray[n - 1];
    }

    private ReflectionUtils() {
    }

    public static <T> VersionHandler<T> v(int n, T t) {
        return new VersionHandler(n, t);
    }

    public static <T> CallableVersionHandler<T> v(int n, Callable<T> callable) {
        return new CallableVersionHandler(n, callable);
    }

    public static boolean supports(int n) {
        return MINOR_NUMBER >= n;
    }

    public static boolean supportsPatch(int n) {
        return PATCH_NUMBER >= n;
    }

    @Nullable
    public static Class<?> getNMSClass(@Nonnull String string, @Nonnull String string2) {
        if (ReflectionUtils.supports(17)) {
            string2 = string + '.' + string2;
        }
        return ReflectionUtils.getNMSClass(string2);
    }

    @Nullable
    public static Class<?> getNMSClass(@Nonnull String string) {
        try {
            return Class.forName(NMS_PACKAGE + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static CompletableFuture<Void> sendPacket(@Nonnull Player player, Object ... objectArray) {
        return CompletableFuture.runAsync(() -> ReflectionUtils.sendPacketSync(player, objectArray)).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    public static void sendPacketSync(@Nonnull Player player, Object ... objectArray) {
        try {
            Object object = GET_HANDLE.invoke(player);
            Object object2 = PLAYER_CONNECTION.invoke(object);
            if (object2 != null) {
                for (Object object3 : objectArray) {
                    SEND_PACKET.invoke(object2, object3);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Nullable
    public static Object getHandle(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get handle of null player");
        try {
            return GET_HANDLE.invoke(player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Object getConnection(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get connection of null player");
        try {
            Object object = GET_HANDLE.invoke(player);
            return PLAYER_CONNECTION.invoke(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getCraftClass(@Nonnull String string) {
        try {
            return Class.forName(CRAFTBUKKIT_PACKAGE + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> getArrayClass(String string, boolean bl) {
        string = "[L" + (bl ? NMS_PACKAGE : CRAFTBUKKIT_PACKAGE) + string + ';';
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> toArrayClass(Class<?> clazz) {
        try {
            return Class.forName("[L" + clazz.getName() + ';');
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var4_13;
        Object object;
        Object object3 = null;
        for (Package package_ : Package.getPackages()) {
            object = package_.getName();
            if (!((String)object).startsWith("org.bukkit.craftbukkit.v")) continue;
            object3 = package_.getName().split("\\.")[3];
            try {
                Class.forName("org.bukkit.craftbukkit." + (String)object3 + ".entity.CraftPlayer");
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object3 = null;
            }
        }
        if (object3 == null) {
            throw new IllegalArgumentException("Failed to parse server version. Could not find any package starting with name: 'org.bukkit.craftbukkit.v'");
        }
        NMS_VERSION = object3;
        if (((String[])(object3 = NMS_VERSION.substring(1).split("_"))).length < 1) {
            throw new IllegalStateException("Version number division error: " + Arrays.toString(object3) + ' ' + ReflectionUtils.getVersionInformation());
        }
        String string = object3[1];
        try {
            MINOR_NUMBER = Integer.parseInt(string);
            if (MINOR_NUMBER < 0) {
                throw new IllegalStateException("Negative minor number? " + string + ' ' + ReflectionUtils.getVersionInformation());
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to parse minor number: " + string + ' ' + ReflectionUtils.getVersionInformation(), throwable);
        }
        Object object2 = Pattern.compile("^\\d+\\.\\d+\\.(\\d+)").matcher(Bukkit.getBukkitVersion());
        if (((Matcher)object2).find()) {
            try {
                PATCH_NUMBER = Integer.parseInt(((Matcher)object2).group(1));
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to parse minor number: " + object2 + ' ' + ReflectionUtils.getVersionInformation(), throwable);
            }
        } else {
            PATCH_NUMBER = 0;
        }
        CRAFTBUKKIT_PACKAGE = "org.bukkit.craftbukkit." + NMS_VERSION + '.';
        NMS_PACKAGE = ReflectionUtils.v(17, "net.minecraft.").orElse("net.minecraft.server." + NMS_VERSION + '.');
        object3 = ReflectionUtils.getNMSClass("server.level", "EntityPlayer");
        Class<?> clazz = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        object2 = ReflectionUtils.getNMSClass("server.network", "PlayerConnection");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object var4_11 = null;
        object = null;
        MethodHandle methodHandle = null;
        try {
            methodHandle = lookup.findGetter((Class<?>)object3, ReflectionUtils.v(20, "c").v(17, "b").orElse("playerConnection"), (Class<?>)object2);
            object = lookup.findVirtual(clazz, "getHandle", MethodType.methodType(object3));
            MethodHandle methodHandle2 = lookup.findVirtual((Class<?>)object2, ReflectionUtils.v(18, "a").orElse("sendPacket"), MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass("network.protocol", "Packet")));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        PLAYER_CONNECTION = methodHandle;
        SEND_PACKET = var4_13;
        GET_HANDLE = object;
    }

    public static final class VersionHandler<T> {
        private int version;
        private T handle;

        private VersionHandler(int n, T t) {
            if (ReflectionUtils.supports(n)) {
                this.version = n;
                this.handle = t;
            }
        }

        public VersionHandler<T> v(int n, T t) {
            if (n == this.version) {
                throw new IllegalArgumentException("Cannot have duplicate version handles for version: " + n);
            }
            if (n > this.version && ReflectionUtils.supports(n)) {
                this.version = n;
                this.handle = t;
            }
            return this;
        }

        public T orElse(T t) {
            return this.version == 0 ? t : this.handle;
        }
    }

    public static final class CallableVersionHandler<T> {
        private int version;
        private Callable<T> handle;

        private CallableVersionHandler(int n, Callable<T> callable) {
            if (ReflectionUtils.supports(n)) {
                this.version = n;
                this.handle = callable;
            }
        }

        public CallableVersionHandler<T> v(int n, Callable<T> callable) {
            if (n == this.version) {
                throw new IllegalArgumentException("Cannot have duplicate version handles for version: " + n);
            }
            if (n > this.version && ReflectionUtils.supports(n)) {
                this.version = n;
                this.handle = callable;
            }
            return this;
        }

        public T orElse(Callable<T> callable) {
            try {
                return (this.version == 0 ? callable : this.handle).call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

