/*
 * Decompiled with CFR 0.152.
 */
package com.dumptruckman.bukkit.configuration.util;

import com.dumptruckman.bukkit.configuration.SerializableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.error.YAMLException;

public class SerializationHelper {
    private static final Logger LOG = Logger.getLogger(SerializationHelper.class.getName());

    public static Object serialize(@NotNull Object collection) {
        if (collection instanceof Object[]) {
            collection = new ArrayList<Object>(Arrays.asList((Object[])collection));
        }
        if (collection instanceof Set && !(collection instanceof SerializableSet)) {
            collection = new SerializableSet((Set)collection);
        }
        if (collection instanceof ConfigurationSection) {
            return SerializationHelper.buildMap(((ConfigurationSection)collection).getValues(false));
        }
        if (collection instanceof Map) {
            return SerializationHelper.buildMap((Map)((Object)collection));
        }
        if (collection instanceof List) {
            return SerializationHelper.buildList((List)collection);
        }
        if (collection instanceof ConfigurationSerializable) {
            ConfigurationSerializable configurationSerializable = (ConfigurationSerializable)collection;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("==", ConfigurationSerialization.getAlias(configurationSerializable.getClass()));
            linkedHashMap.putAll(configurationSerializable.serialize());
            return SerializationHelper.buildMap(linkedHashMap);
        }
        return collection;
    }

    @NotNull
    private static Map<String, Object> buildMap(@NotNull Map<?, ?> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                linkedHashMap.put(entry.getKey().toString(), SerializationHelper.serialize(entry.getValue()));
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Error while building configuration map.", exception);
        }
        return linkedHashMap;
    }

    private static List<Object> buildList(@NotNull Collection<?> collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        try {
            for (Object obj : collection) {
                arrayList.add(SerializationHelper.serialize(obj));
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Error while building configuration list.", exception);
        }
        return arrayList;
    }

    public static Object deserialize(@NotNull Map<?, ?> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                linkedHashMap.put(entry.getKey().toString(), SerializationHelper.deserialize((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof List) {
                linkedHashMap.put(entry.getKey().toString(), SerializationHelper.deserialize((List)entry.getValue()));
                continue;
            }
            linkedHashMap.put(entry.getKey().toString(), entry.getValue());
        }
        if (linkedHashMap.containsKey("==")) {
            try {
                return ConfigurationSerialization.deserializeObject(linkedHashMap);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new YAMLException("Could not deserialize object", illegalArgumentException);
            }
        }
        return linkedHashMap;
    }

    private static Object deserialize(@NotNull List<?> list2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
        for (Object obj : list2) {
            if (obj instanceof Map) {
                arrayList.add(SerializationHelper.deserialize((Map)obj));
                continue;
            }
            if (obj instanceof List) {
                arrayList.add(SerializationHelper.deserialize((List)obj));
                continue;
            }
            arrayList.add(obj);
        }
        return arrayList;
    }
}

