/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class AnnotatedTypeImpl
implements AnnotatedType {
    protected Type type;
    protected Map<Class<? extends Annotation>, Annotation> annotations;

    AnnotatedTypeImpl(Type type) {
        this(type, new Annotation[0]);
    }

    AnnotatedTypeImpl(Type type, Annotation[] annotationArray) {
        this.type = Objects.requireNonNull(type);
        this.annotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationArray) {
            this.annotations.put(annotation.annotationType(), annotation);
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.annotations.get(clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AnnotatedType)) {
            return false;
        }
        AnnotatedType annotatedType = (AnnotatedType)object;
        return this.getType().equals(annotatedType.getType()) && Arrays.equals(this.getAnnotations(), annotatedType.getAnnotations());
    }

    public int hashCode() {
        return 127 * this.getType().hashCode() ^ Arrays.hashCode(this.getAnnotations());
    }

    public String toString() {
        return this.annotationsString() + GenericTypeReflector.getTypeName(this.type);
    }

    String annotationsString() {
        return this.annotations.isEmpty() ? "" : this.annotations.values().stream().map(Annotation::toString).collect(Collectors.joining(", ")) + " ";
    }

    String typesString(AnnotatedType[] annotatedTypeArray) {
        return Arrays.stream(annotatedTypeArray).map(Object::toString).collect(Collectors.joining(", "));
    }
}

