/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedTypeImpl;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

class AnnotatedWildcardTypeImpl
extends AnnotatedTypeImpl
implements AnnotatedWildcardType {
    private AnnotatedType[] lowerBounds;
    private AnnotatedType[] upperBounds;

    AnnotatedWildcardTypeImpl(WildcardType wildcardType, Annotation[] annotationArray, AnnotatedType[] annotatedTypeArray, AnnotatedType[] annotatedTypeArray2) {
        super(wildcardType, annotationArray);
        if (annotatedTypeArray == null || annotatedTypeArray.length == 0) {
            annotatedTypeArray = new AnnotatedType[]{};
        }
        if (annotatedTypeArray2 == null || annotatedTypeArray2.length == 0) {
            annotatedTypeArray2 = new AnnotatedType[]{GenericTypeReflector.annotate(Object.class)};
        }
        AnnotatedWildcardTypeImpl.validateBounds(wildcardType, annotatedTypeArray, annotatedTypeArray2);
        this.lowerBounds = annotatedTypeArray;
        this.upperBounds = annotatedTypeArray2;
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AnnotatedWildcardType) || !super.equals(object)) {
            return false;
        }
        return GenericTypeReflector.typeArraysEqual(this.lowerBounds, ((AnnotatedWildcardType)object).getAnnotatedLowerBounds()) && GenericTypeReflector.typeArraysEqual(this.upperBounds, ((AnnotatedWildcardType)object).getAnnotatedUpperBounds());
    }

    @Override
    public int hashCode() {
        return 127 * super.hashCode() ^ GenericTypeReflector.hashCode(this.lowerBounds) + GenericTypeReflector.hashCode(this.upperBounds);
    }

    @Override
    public String toString() {
        if (this.lowerBounds.length > 0) {
            return this.annotationsString() + "? super " + this.typesString(this.lowerBounds);
        }
        if (this.upperBounds.length == 0 || this.upperBounds[0].getType() == Object.class) {
            return this.annotationsString() + "?";
        }
        return this.annotationsString() + "? extends " + this.typesString(this.upperBounds);
    }

    private static void validateBounds(WildcardType wildcardType, AnnotatedType[] annotatedTypeArray, AnnotatedType[] annotatedTypeArray2) {
        int n;
        if (wildcardType.getLowerBounds().length != annotatedTypeArray.length) {
            throw new IllegalArgumentException("Incompatible lower bounds " + Arrays.toString(annotatedTypeArray) + " for type " + wildcardType.toString());
        }
        if (wildcardType.getUpperBounds().length != annotatedTypeArray2.length) {
            throw new IllegalArgumentException("Incompatible upper bounds " + Arrays.toString(annotatedTypeArray2) + " for type " + wildcardType.toString());
        }
        for (n = 0; n < wildcardType.getLowerBounds().length; ++n) {
            if (GenericTypeReflector.erase(wildcardType.getLowerBounds()[n]) == GenericTypeReflector.erase(annotatedTypeArray[n].getType())) continue;
            throw new IllegalArgumentException("Bound " + annotatedTypeArray[n].getType() + " incompatible with " + wildcardType.getLowerBounds()[n] + " in type " + wildcardType.toString());
        }
        for (n = 0; n < wildcardType.getUpperBounds().length; ++n) {
            if (GenericTypeReflector.erase(wildcardType.getUpperBounds()[n]) == GenericTypeReflector.erase(annotatedTypeArray2[n].getType())) continue;
            throw new IllegalArgumentException("Bound " + annotatedTypeArray2[n].getType() + " incompatible with " + wildcardType.getUpperBounds()[n] + " in type " + wildcardType.toString());
        }
    }
}

