/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.VarMap;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class CaptureTypeImpl
implements CaptureType {
    private final WildcardType wildcard;
    private final TypeVariable<?> variable;
    private final Type[] lowerBounds;
    private Type[] upperBounds;

    CaptureTypeImpl(WildcardType wildcardType, TypeVariable<?> typeVariable) {
        this.wildcard = wildcardType;
        this.variable = typeVariable;
        this.lowerBounds = wildcardType.getLowerBounds();
    }

    void init(VarMap varMap) {
        ArrayList<Type> arrayList = new ArrayList<Type>(Arrays.asList(varMap.map(this.variable.getBounds())));
        List<Type> list2 = Arrays.asList(this.wildcard.getUpperBounds());
        if (list2.size() > 0 && list2.get(0) == Object.class) {
            arrayList.addAll(list2.subList(1, list2.size()));
        } else {
            arrayList.addAll(list2);
        }
        this.upperBounds = new Type[arrayList.size()];
        arrayList.toArray(this.upperBounds);
    }

    @Override
    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    @Override
    public Type[] getUpperBounds() {
        assert (this.upperBounds != null);
        return (Type[])this.upperBounds.clone();
    }

    @Override
    public void setUpperBounds(Type[] typeArray) {
        this.upperBounds = typeArray;
    }

    @Override
    public TypeVariable<?> getTypeVariable() {
        return this.variable;
    }

    @Override
    public WildcardType getWildcardType() {
        return this.wildcard;
    }

    public String toString() {
        return "capture of " + this.wildcard;
    }
}

