/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedArrayTypeImpl;
import io.leangen.geantyref.AnnotatedCaptureType;
import io.leangen.geantyref.AnnotatedCaptureTypeImpl;
import io.leangen.geantyref.AnnotatedTypeVariableImpl;
import io.leangen.geantyref.AnnotatedWildcardTypeImpl;
import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.GenericArrayTypeImpl;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.WildcardTypeImpl;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class TypeVisitor {
    private final Map<TypeVariable, AnnotatedTypeVariable> varCache = new IdentityHashMap<TypeVariable, AnnotatedTypeVariable>();
    private final Map<AnnotatedCaptureCacheKey, AnnotatedType> captureCache = new HashMap<AnnotatedCaptureCacheKey, AnnotatedType>();

    protected AnnotatedType visitParameterizedType(AnnotatedParameterizedType annotatedParameterizedType) {
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedParameterizedType.getAnnotatedActualTypeArguments()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        return GenericTypeReflector.replaceParameters(annotatedParameterizedType, annotatedTypeArray);
    }

    protected AnnotatedType visitWildcardType(AnnotatedWildcardType annotatedWildcardType) {
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedWildcardType.getAnnotatedLowerBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        AnnotatedType[] annotatedTypeArray2 = (AnnotatedType[])Arrays.stream(annotatedWildcardType.getAnnotatedUpperBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        WildcardTypeImpl wildcardTypeImpl = new WildcardTypeImpl((Type[])Arrays.stream(annotatedTypeArray2).map(AnnotatedType::getType).toArray(Type[]::new), (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new));
        return new AnnotatedWildcardTypeImpl(wildcardTypeImpl, annotatedWildcardType.getAnnotations(), annotatedTypeArray, annotatedTypeArray2);
    }

    protected AnnotatedType visitVariable(AnnotatedTypeVariable annotatedTypeVariable) {
        TypeVariable typeVariable = (TypeVariable)annotatedTypeVariable.getType();
        if (this.varCache.containsKey(typeVariable)) {
            return this.varCache.get(typeVariable);
        }
        AnnotatedTypeVariableImpl annotatedTypeVariableImpl = new AnnotatedTypeVariableImpl(typeVariable, annotatedTypeVariable.getAnnotations());
        this.varCache.put(typeVariable, annotatedTypeVariableImpl);
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedTypeVariable.getAnnotatedBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        annotatedTypeVariableImpl.init(annotatedTypeArray);
        return annotatedTypeVariableImpl;
    }

    protected AnnotatedType visitArray(AnnotatedArrayType annotatedArrayType) {
        AnnotatedType annotatedType = GenericTypeReflector.transform(annotatedArrayType.getAnnotatedGenericComponentType(), this);
        return new AnnotatedArrayTypeImpl(GenericArrayTypeImpl.createArrayType(annotatedType.getType()), annotatedArrayType.getAnnotations(), annotatedType);
    }

    protected AnnotatedType visitCaptureType(AnnotatedCaptureType annotatedCaptureType) {
        AnnotatedCaptureCacheKey annotatedCaptureCacheKey = new AnnotatedCaptureCacheKey(annotatedCaptureType);
        if (this.captureCache.containsKey(annotatedCaptureCacheKey)) {
            return this.captureCache.get(annotatedCaptureCacheKey);
        }
        AnnotatedCaptureTypeImpl annotatedCaptureTypeImpl = new AnnotatedCaptureTypeImpl((CaptureType)annotatedCaptureType.getType(), (AnnotatedWildcardType)GenericTypeReflector.transform(annotatedCaptureType.getAnnotatedWildcardType(), this), (AnnotatedTypeVariable)GenericTypeReflector.transform(annotatedCaptureType.getAnnotatedTypeVariable(), this), null, annotatedCaptureType.getAnnotations());
        this.captureCache.put(annotatedCaptureCacheKey, annotatedCaptureTypeImpl);
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedCaptureType.getAnnotatedUpperBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        annotatedCaptureTypeImpl.setAnnotatedUpperBounds(annotatedTypeArray);
        return annotatedCaptureTypeImpl;
    }

    protected AnnotatedType visitClass(AnnotatedType annotatedType) {
        return annotatedType;
    }

    protected AnnotatedType visitUnmatched(AnnotatedType annotatedType) {
        return annotatedType;
    }

    private static class AnnotatedCaptureCacheKey {
        AnnotatedCaptureType capture;
        CaptureType raw;

        AnnotatedCaptureCacheKey(AnnotatedCaptureType annotatedCaptureType) {
            this.capture = annotatedCaptureType;
            this.raw = (CaptureType)annotatedCaptureType.getType();
        }

        public int hashCode() {
            return 127 * this.raw.getWildcardType().hashCode() ^ this.raw.getTypeVariable().hashCode() ^ GenericTypeReflector.hashCode(Arrays.stream(this.capture.getAnnotations()));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AnnotatedCaptureCacheKey)) {
                return false;
            }
            AnnotatedCaptureCacheKey annotatedCaptureCacheKey = (AnnotatedCaptureCacheKey)object;
            return this.capture == annotatedCaptureCacheKey.capture || new GenericTypeReflector.CaptureCacheKey(this.raw).equals(new GenericTypeReflector.CaptureCacheKey(annotatedCaptureCacheKey.raw)) && Arrays.equals(this.capture.getAnnotations(), annotatedCaptureCacheKey.capture.getAnnotations());
        }
    }
}

