/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.api;

import java.util.UUID;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.guild.GuildRole;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lme/glaremasters/guilds/api/GuildsAPI;", "", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "cooldownHandler", "Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "(Lme/glaremasters/guilds/guild/GuildHandler;Lme/glaremasters/guilds/cooldowns/CooldownHandler;)V", "getCooldownHandler", "()Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "getGuild", "Lme/glaremasters/guilds/guild/Guild;", "uuid", "Ljava/util/UUID;", "name", "", "player", "Lorg/bukkit/OfflinePlayer;", "getGuildByPlayerId", "getGuildMember", "Lme/glaremasters/guilds/guild/GuildMember;", "getGuildRole", "Lme/glaremasters/guilds/guild/GuildRole;", "Lorg/bukkit/entity/Player;", "getGuildVault", "Lorg/bukkit/inventory/Inventory;", "guild", "vaultNumber", "", "Guilds"})
public final class GuildsAPI {
    @NotNull
    private final GuildHandler guildHandler;
    @NotNull
    private final CooldownHandler cooldownHandler;

    public GuildsAPI(@NotNull GuildHandler guildHandler, @NotNull CooldownHandler cooldownHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"guildHandler");
        Intrinsics.checkNotNullParameter((Object)cooldownHandler, (String)"cooldownHandler");
        this.guildHandler = guildHandler;
        this.cooldownHandler = cooldownHandler;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        return this.guildHandler;
    }

    @NotNull
    public final CooldownHandler getCooldownHandler() {
        return this.cooldownHandler;
    }

    @Nullable
    public final Guild getGuild(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        return this.guildHandler.getGuild(offlinePlayer);
    }

    @Nullable
    public final Guild getGuild(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"uuid");
        return this.guildHandler.getGuild(uUID);
    }

    @Nullable
    public final Guild getGuild(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        return this.guildHandler.getGuild(string);
    }

    @Nullable
    public final Guild getGuildByPlayerId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"uuid");
        return this.guildHandler.getGuildByPlayerId(uUID);
    }

    @Nullable
    public final GuildMember getGuildMember(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"uuid");
        return this.guildHandler.getGuildMember(uUID);
    }

    @NotNull
    public final Inventory getGuildVault(@NotNull Guild guild, int n) {
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Inventory inventory = this.guildHandler.getGuildVault(guild, n);
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"guildHandler.getGuildVault(guild, vaultNumber)");
        return inventory;
    }

    @Nullable
    public final GuildRole getGuildRole(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = this.getGuild((OfflinePlayer)player);
        return object != null && (object = ((Guild)object).getMember(player.getUniqueId())) != null ? ((GuildMember)object).getRole() : null;
    }
}

