/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.challenges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.challenges.GuildWarEndEvent;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.configuration.sections.WarSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.guild.GuildRolePerm;
import me.glaremasters.guilds.libs.commands.ACFBukkitUtil;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChallengeHandler {
    private final Set<GuildChallenge> challenges = new HashSet<GuildChallenge>();
    private final Guilds guilds;

    public ChallengeHandler(Guilds guilds) {
        this.guilds = guilds;
    }

    public void loadChallenges() {
        try {
            Set<GuildChallenge> set = this.guilds.getDatabase().getChallengeAdapter().getAllChallenges();
            for (GuildChallenge guildChallenge : set) {
                if (!guildChallenge.isCompleted()) {
                    guildChallenge.setCompleted(true);
                }
                this.challenges.add(guildChallenge);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveData() {
        this.guilds.getDatabase().getChallengeAdapter().saveChallenges(this.challenges);
    }

    public GuildChallenge createNewChallenge(@NotNull Guild guild, @NotNull Guild guild2, int n, int n2, @NotNull Arena arena) {
        return new GuildChallenge(UUID.randomUUID(), System.currentTimeMillis(), guild, guild2, false, false, false, false, n, n2, new ArrayList<UUID>(), new ArrayList<UUID>(), arena, null, null, new LinkedHashMap<UUID, String>(), new LinkedHashMap<UUID, String>());
    }

    public void addChallenge(@NotNull GuildChallenge guildChallenge) {
        this.challenges.add(guildChallenge);
    }

    public void removeChallenge(@NotNull GuildChallenge guildChallenge) {
        this.challenges.remove(guildChallenge);
    }

    public void removeChallenge(@NotNull UUID uUID) {
        this.challenges.removeIf(guildChallenge -> guildChallenge.getId().equals(uUID));
    }

    public GuildChallenge getChallenge(@NotNull UUID uUID) {
        return this.challenges.stream().filter(guildChallenge -> guildChallenge.getId().equals(uUID)).findAny().orElse(null);
    }

    public GuildChallenge getChallenge(@NotNull Guild guild) {
        return this.challenges.stream().filter(guildChallenge -> (guildChallenge.getChallenger() == guild || guildChallenge.getDefender() == guild) && !guildChallenge.isCompleted()).findFirst().orElse(null);
    }

    public GuildChallenge getChallenge(@NotNull Player player) {
        return this.getActiveChallenges().stream().filter(guildChallenge -> (guildChallenge.getAliveChallengers().containsKey(player.getUniqueId()) || guildChallenge.getAliveDefenders().containsKey(player.getUniqueId())) && !guildChallenge.isCompleted()).findAny().orElse(null);
    }

    public List<GuildChallenge> getActiveChallenges() {
        return this.challenges.stream().filter(GuildChallenge::isStarted).collect(Collectors.toList());
    }

    public List<Player> getOnlineDefenders(@NotNull Guild guild) {
        List list2 = guild.getOnlineMembers().stream().filter(guildMember -> guildMember.getRole().hasPerm(GuildRolePerm.INITIATE_WAR)).collect(Collectors.toList());
        return list2.stream().map(guildMember -> Bukkit.getPlayer((UUID)guildMember.getUuid())).collect(Collectors.toList());
    }

    public void pingOnlineDefenders(@NotNull Guild guild, @NotNull PaperCommandManager paperCommandManager, @NotNull String string, int n) {
        this.getOnlineDefenders(guild).forEach(player -> paperCommandManager.getCommandIssuer(player).sendInfo(Messages.WAR__INCOMING_CHALLENGE, "{guild}", string, "{amount}", String.valueOf(n)));
    }

    public boolean checkEnoughOnline(@NotNull Guild guild, @NotNull Guild guild2, int n) {
        return guild.getOnlineAsPlayers().size() >= n && guild2.getOnlineAsPlayers().size() >= n;
    }

    public boolean checkEnoughJoined(@NotNull GuildChallenge guildChallenge) {
        return guildChallenge.getChallengePlayers().size() >= guildChallenge.getMinPlayersPerSide() && guildChallenge.getDefendPlayers().size() >= guildChallenge.getMinPlayersPerSide();
    }

    public void prepareFinalList(@NotNull List<UUID> list2, @NotNull GuildChallenge guildChallenge, @NotNull String string) {
        LinkedHashMap<UUID, String> linkedHashMap = new LinkedHashMap<UUID, String>();
        list2.forEach(uUID -> {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player != null) {
                linkedHashMap.putIfAbsent((UUID)uUID, ACFBukkitUtil.fullLocationToString(player.getLocation()));
            }
        });
        if (string.equalsIgnoreCase("challenger")) {
            guildChallenge.setAliveChallengers(linkedHashMap);
        } else {
            guildChallenge.setAliveDefenders(linkedHashMap);
        }
    }

    public void sendToArena(@NotNull Map<UUID, String> map, @Nullable Location location) {
        map.keySet().forEach(uUID -> {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player != null) {
                player.teleport(location);
            }
        });
    }

    public void exitArena(Player player, GuildChallenge guildChallenge, Guilds guilds) {
        String string = this.getAllPlayersAlive(guildChallenge).get(player.getUniqueId());
        if (string != null) {
            player.teleport(ACFBukkitUtil.stringToLocation(string));
            guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.WAR__TELEPORTED_BACK, new String[0]);
            player.setHealth(player.getMaxHealth());
        }
    }

    public Map<UUID, String> getAllPlayersAlive(@NotNull GuildChallenge guildChallenge) {
        return Stream.of(guildChallenge.getAliveChallengers(), guildChallenge.getAliveDefenders()).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void teleportRemaining(@NotNull GuildChallenge guildChallenge) {
        this.getAllPlayersAlive(guildChallenge).forEach((uUID, string) -> {
            Location location = ACFBukkitUtil.stringToLocation(string);
            Player player = Bukkit.getPlayer((UUID)uUID);
            Bukkit.getScheduler().runTaskLater((Plugin)this.guilds, () -> player.teleport(location), 1L);
        });
    }

    public void removePlayer(@NotNull Player player) {
        GuildChallenge guildChallenge = this.getChallenge(player);
        if (guildChallenge != null) {
            guildChallenge.getAliveDefenders().remove(player.getUniqueId());
            guildChallenge.getAliveChallengers().remove(player.getUniqueId());
        }
    }

    public boolean checkIfOver(@NotNull GuildChallenge guildChallenge) {
        if (guildChallenge.getAliveChallengers().keySet().size() == 0) {
            guildChallenge.setWinner(guildChallenge.getDefender());
            guildChallenge.setLoser(guildChallenge.getChallenger());
            guildChallenge.getDefender().getGuildScore().addWin();
            guildChallenge.getChallenger().getGuildScore().addLoss();
            return true;
        }
        if (guildChallenge.getAliveDefenders().keySet().size() == 0) {
            guildChallenge.setWinner(guildChallenge.getChallenger());
            guildChallenge.setLoser(guildChallenge.getDefender());
            guildChallenge.getDefender().getGuildScore().addLoss();
            guildChallenge.getChallenger().getGuildScore().addWin();
            return true;
        }
        return false;
    }

    public void announceWinner(@NotNull GuildChallenge guildChallenge, @NotNull PaperCommandManager paperCommandManager) {
        guildChallenge.getDefender().sendMessage(paperCommandManager, Messages.WAR__WINNER, "{guild}", guildChallenge.getWinner().getName());
        guildChallenge.getChallenger().sendMessage(paperCommandManager, Messages.WAR__WINNER, "{guild}", guildChallenge.getWinner().getName());
    }

    public void announceDeath(@NotNull GuildChallenge guildChallenge, @NotNull Guilds guilds, @NotNull Player player, @NotNull Player player2, @NotNull Cause cause) {
        Messages messages;
        switch (cause.toString()) {
            case "PLAYER_KILLED_PLAYER": {
                messages = Messages.WAR__PLAYER_KILLED_PLAYER;
                break;
            }
            case "PLAYER_KILLED_UNKNOWN": {
                messages = Messages.WAR__PLAYER_KILLED_OTHER;
                break;
            }
            case "PLAYER_KILLED_QUIT": {
                messages = Messages.WAR__PLAYER_KILLED_QUIT;
                break;
            }
            default: {
                messages = Messages.WAR__PLAYER_KILLED_OTHER;
            }
        }
        this.getAllPlayersAlive(guildChallenge).keySet().forEach(uUID -> guilds.getCommandManager().getCommandIssuer(Bukkit.getPlayer((UUID)uUID)).sendInfo(messages, "{player}", player.getName(), "{killer}", player2.getName()));
    }

    public void giveRewards(@NotNull SettingsManager settingsManager, @NotNull GuildChallenge guildChallenge) {
        UUID uUID2 = guildChallenge.getWinner().getId();
        List<UUID> list2 = uUID2 == guildChallenge.getChallenger().getId() ? guildChallenge.getChallengePlayers() : guildChallenge.getDefendPlayers();
        List<String> list3 = settingsManager.getProperty(WarSettings.WAR_REWARDS);
        if (settingsManager.getProperty(WarSettings.WAR_REWARDS_ENABLED).booleanValue()) {
            list2.forEach(uUID -> {
                Player player = Bukkit.getPlayer((UUID)uUID);
                if (player != null) {
                    list3.forEach(string -> {
                        string = string.replace("{player}", player.getName());
                        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), string);
                    });
                }
            });
        }
    }

    public boolean notOnCooldown(@NotNull Guild guild, @NotNull SettingsManager settingsManager) {
        long l = TimeUnit.MINUTES.toMillis(settingsManager.getProperty(WarSettings.DEFEND_COOLDOWN).intValue());
        long l2 = guild.getLastDefended();
        long l3 = System.currentTimeMillis();
        if (l2 == 0L) {
            return true;
        }
        return l3 - l2 > l;
    }

    public void handleFinish(@NotNull Guilds guilds, @NotNull SettingsManager settingsManager, @NotNull Player player, @NotNull GuildChallenge guildChallenge) {
        this.removePlayer(player);
        if (this.checkIfOver(guildChallenge)) {
            guildChallenge.setStarted(false);
            guildChallenge.setCompleted(true);
            guildChallenge.getArena().setInUse(false);
            this.announceWinner(guildChallenge, guilds.getCommandManager());
            this.teleportRemaining(guildChallenge);
            this.giveRewards(settingsManager, guildChallenge);
            if (settingsManager.getProperty(WarSettings.ENABLE_POST_CHALLENGE_COMMANDS).booleanValue()) {
                settingsManager.getProperty(WarSettings.POST_CHALLENGE_COMMANDS).forEach(string -> {
                    string = string.replace("{challenger}", guildChallenge.getChallenger().getName());
                    string = string.replace("{defender}", guildChallenge.getDefender().getName());
                    string = string.replace("{winner}", guildChallenge.getWinner().getName());
                    string = string.replace("{loser}", guildChallenge.getLoser().getName());
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), string);
                });
            }
            Bukkit.getPluginManager().callEvent((Event)new GuildWarEndEvent(guildChallenge.getChallenger(), guildChallenge.getDefender(), guildChallenge.getWinner()));
            try {
                this.saveData();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public Set<GuildChallenge> getChallenges() {
        return this.challenges;
    }

    public static enum Cause {
        PLAYER_KILLED_PLAYER,
        PLAYER_KILLED_UNKNOWN,
        PLAYER_KILLED_QUIT;

    }
}

