/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.gui;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.exceptions.InvalidTierException;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guis.BuffGUI;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.gui.guis.PaginatedGui;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.Unit;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.taskchain.TaskChain;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lme/glaremasters/guilds/commands/gui/CommandGUI;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "buff", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "info", "list", "members", "vault", "Guilds"})
public final class CommandGUI
extends BaseCommand {
    @Dependency
    public Guilds guilds;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @Subcommand(value="buff")
    @Description(value="{@@descriptions.buff}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.buff")
    public final void buff(@NotNull Player player, @Conditions(value="perm:perm=ACTIVATE_BUFF") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        if (!guild.getTier().isUseBuffs()) {
            throw new InvalidTierException();
        }
        BuffGUI buffGUI = this.getGuilds().getGuiHandler().getBuffs();
        PaperCommandManager paperCommandManager = this.getGuilds().getCommandManager();
        Intrinsics.checkNotNullExpressionValue((Object)paperCommandManager, (String)"guilds.commandManager");
        buffGUI.get(player, guild, paperCommandManager).open((HumanEntity)player);
    }

    @Subcommand(value="info")
    @Description(value="{@@descriptions.info}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.info")
    public final void info(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        this.getGuilds().getGuiHandler().getInfo().get(guild, player).open((HumanEntity)player);
    }

    @Subcommand(value="list")
    @Description(value="{@@descriptions.list}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.list")
    public final void list(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TaskChain taskChain = Guilds.newChain();
        taskChain.async(() -> CommandGUI.list$lambda$0(taskChain, this, player)).sync(arg_0 -> CommandGUI.list$lambda$1(taskChain, player, arg_0)).execute();
    }

    @Subcommand(value="members")
    @Description(value="{@@descriptions.members}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.members")
    public final void members(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        this.getGuilds().getGuiHandler().getMembers().get(guild, player).open((HumanEntity)player);
    }

    @Subcommand(value="vault")
    @Description(value="{@@descriptions.vault}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.vault")
    public final void vault(@NotNull Player player, @Conditions(value="perm:perm=OPEN_VAULT") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        this.getGuilds().getGuiHandler().getVaults().get(guild, player).open((HumanEntity)player);
    }

    private static final void list$lambda$0(TaskChain taskChain, CommandGUI commandGUI, Player player) {
        Intrinsics.checkNotNullParameter((Object)commandGUI, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"$player");
        taskChain.setTaskData("data", commandGUI.getGuilds().getGuiHandler().getList().get(player));
    }

    private static final Unit list$lambda$1(TaskChain taskChain, Player player, Object object) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"$player");
        Object r = taskChain.getTaskData("data");
        Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type dev.triumphteam.gui.guis.PaginatedGui");
        ((PaginatedGui)r).open((HumanEntity)player);
        return Unit.INSTANCE;
    }
}

