/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.homes;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildSetHomeEvent;
import me.glaremasters.guilds.configuration.sections.CooldownSettings;
import me.glaremasters.guilds.configuration.sections.CostSettings;
import me.glaremasters.guilds.cooldowns.Cooldown;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildHome;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.libs.taskchain.TaskChain;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.EconomyUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&H\u0007J\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007J\u001a\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lme/glaremasters/guilds/commands/homes/CommandHome;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "cooldownHandler", "Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "getCooldownHandler", "()Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "setCooldownHandler", "(Lme/glaremasters/guilds/cooldowns/CooldownHandler;)V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "getEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "setEconomy", "(Lnet/milkbowl/vault/economy/Economy;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "delete", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "home", "set", "Guilds"})
public final class CommandHome
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;
    @Dependency
    public CooldownHandler cooldownHandler;
    @Dependency
    public Economy economy;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final CooldownHandler getCooldownHandler() {
        CooldownHandler cooldownHandler = this.cooldownHandler;
        if (cooldownHandler != null) {
            return cooldownHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cooldownHandler");
        return null;
    }

    public final void setCooldownHandler(@NotNull CooldownHandler cooldownHandler) {
        Intrinsics.checkNotNullParameter((Object)cooldownHandler, (String)"<set-?>");
        this.cooldownHandler = cooldownHandler;
    }

    @NotNull
    public final Economy getEconomy() {
        Economy economy = this.economy;
        if (economy != null) {
            return economy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
        return null;
    }

    public final void setEconomy(@NotNull Economy economy) {
        Intrinsics.checkNotNullParameter((Object)economy, (String)"<set-?>");
        this.economy = economy;
    }

    @Subcommand(value="delhome")
    @Description(value="{@@descriptions.delhome}")
    @CommandPermission(value="guilds.command.delhome")
    @Syntax(value="")
    public final void delete(@NotNull Player player, @Conditions(value="perm:perm=CHANGE_HOME") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        guild.delHome();
        this.getCurrentCommandIssuer().sendInfo(Messages.SETHOME__DELETED, new String[0]);
    }

    @Subcommand(value="home")
    @Description(value="{@@descriptions.home}")
    @CommandPermission(value="guilds.command.home")
    @Syntax(value="")
    public final void home(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        GuildHome guildHome = guild.getHome();
        if (guildHome == null) {
            throw new ExpectationNotMet(Messages.HOME__NO_HOME_SET);
        }
        GuildHome guildHome2 = guildHome;
        String string = Cooldown.Type.Home.name();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        UUID uUID2 = uUID;
        if (this.getCooldownHandler().hasCooldown(string, uUID2)) {
            String[] stringArray = new String[]{"{amount}", String.valueOf(this.getCooldownHandler().getRemaining(string, uUID2))};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.HOME__COOLDOWN, stringArray);
        }
        CooldownHandler cooldownHandler = this.getCooldownHandler();
        OfflinePlayer offlinePlayer = (OfflinePlayer)player;
        Integer n = this.getSettingsManager().getProperty(CooldownSettings.HOME);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"settingsManager.getProperty(CooldownSettings.HOME)");
        cooldownHandler.addCooldown(offlinePlayer, string, ((Number)n).intValue(), TimeUnit.SECONDS);
        Boolean bl = this.getSettingsManager().getProperty(CooldownSettings.WU_HOME_ENABLED);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"settingsManager.getPrope\u2026Settings.WU_HOME_ENABLED)");
        if (bl.booleanValue() && !player.hasPermission("guilds.warmup.bypass")) {
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"player.location");
            Location location2 = location;
            Integer n2 = this.getSettingsManager().getProperty(CooldownSettings.WU_HOME);
            String[] stringArray = new String[]{"{amount}", String.valueOf(n2)};
            this.getCurrentCommandIssuer().sendInfo(Messages.HOME__WARMUP, stringArray);
            TaskChain taskChain = Guilds.newChain();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"wait");
            taskChain.delay(n2, TimeUnit.SECONDS).sync(() -> CommandHome.home$lambda$0(player, location2, this, guildHome2)).execute();
        } else {
            player.teleport(guildHome2.getAsLocation());
            this.getCurrentCommandIssuer().sendInfo(Messages.HOME__TELEPORTED, new String[0]);
        }
    }

    @Subcommand(value="sethome")
    @Description(value="{@@descriptions.sethome}")
    @CommandPermission(value="guilds.command.sethome")
    @Syntax(value="")
    public final void set(@NotNull Player player, @Conditions(value="perm:perm=CHANGE_HOME") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        String string = Cooldown.Type.SetHome.name();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        UUID uUID2 = uUID;
        if (this.getCooldownHandler().hasCooldown(string, uUID2)) {
            String[] stringArray = new String[]{"{amount}", String.valueOf(this.getCooldownHandler().getRemaining(string, uUID2))};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.SETHOME__COOLDOWN, stringArray);
        }
        Double d = this.getSettingsManager().getProperty(CostSettings.SETHOME);
        double d2 = guild.getBalance();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"cost");
        if (!EconomyUtils.hasEnough(d2, d)) {
            throw new ExpectationNotMet(Messages.BANK__NOT_ENOUGH_BANK);
        }
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"player.location");
        GuildSetHomeEvent guildSetHomeEvent = new GuildSetHomeEvent(player, guild, location);
        Bukkit.getPluginManager().callEvent((Event)guildSetHomeEvent);
        if (guildSetHomeEvent.isCancelled()) {
            return;
        }
        CooldownHandler cooldownHandler = this.getCooldownHandler();
        OfflinePlayer offlinePlayer = (OfflinePlayer)player;
        Integer n = this.getSettingsManager().getProperty(CooldownSettings.SETHOME);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"settingsManager.getPrope\u2026CooldownSettings.SETHOME)");
        cooldownHandler.addCooldown(offlinePlayer, string, ((Number)n).intValue(), TimeUnit.SECONDS);
        guild.setNewHome(player);
        guild.setBalance(guild.getBalance() - d);
        this.getCurrentCommandIssuer().sendInfo(Messages.SETHOME__SUCCESSFUL, new String[0]);
    }

    private static final void home$lambda$0(Player player, Location location, CommandHome commandHome, GuildHome guildHome) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"$loc");
        Intrinsics.checkNotNullParameter((Object)commandHome, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)guildHome, (String)"$home");
        Location location2 = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"player.location");
        Location location3 = location2;
        if (location.distance(location3) > 1.0) {
            commandHome.getGuilds().getCommandManager().getCommandIssuer(player).sendInfo(Messages.HOME__CANCELLED, new String[0]);
        } else {
            player.teleport(guildHome.getAsLocation());
            commandHome.getGuilds().getCommandManager().getCommandIssuer(player).sendInfo(Messages.HOME__TELEPORTED, new String[0]);
        }
    }
}

