/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.management;

import java.util.concurrent.TimeUnit;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildKickEvent;
import me.glaremasters.guilds.configuration.sections.CooldownSettings;
import me.glaremasters.guilds.cooldowns.Cooldown;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.exceptions.InvalidPermissionException;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Single;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.commands.annotation.Values;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.ClaimUtils;
import me.glaremasters.guilds.utils.RoleUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lme/glaremasters/guilds/commands/management/CommandKick;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "cooldownHandler", "Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "getCooldownHandler", "()Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "setCooldownHandler", "(Lme/glaremasters/guilds/cooldowns/CooldownHandler;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "permission", "Lnet/milkbowl/vault/permission/Permission;", "getPermission", "()Lnet/milkbowl/vault/permission/Permission;", "setPermission", "(Lnet/milkbowl/vault/permission/Permission;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "kick", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "name", "", "Guilds"})
public final class CommandKick
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;
    @Dependency
    public CooldownHandler cooldownHandler;
    @Dependency
    public Permission permission;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final CooldownHandler getCooldownHandler() {
        CooldownHandler cooldownHandler = this.cooldownHandler;
        if (cooldownHandler != null) {
            return cooldownHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cooldownHandler");
        return null;
    }

    public final void setCooldownHandler(@NotNull CooldownHandler cooldownHandler) {
        Intrinsics.checkNotNullParameter((Object)cooldownHandler, (String)"<set-?>");
        this.cooldownHandler = cooldownHandler;
    }

    @NotNull
    public final Permission getPermission() {
        Permission permission = this.permission;
        if (permission != null) {
            return permission;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"permission");
        return null;
    }

    public final void setPermission(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"<set-?>");
        this.permission = permission;
    }

    @Subcommand(value="boot|kick")
    @Description(value="{@@descriptions.kick}")
    @CommandPermission(value="guilds.command.boot")
    @CommandCompletion(value="@members")
    @Syntax(value="%name")
    public final void kick(@NotNull Player player, @Conditions(value="perm:perm=KICK") @NotNull Guild guild, @Values(value="@members") @Single @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(name)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        GuildMember guildMember = guild.getMember(offlinePlayer2.getUniqueId());
        if (guildMember == null) {
            String[] stringArray = new String[]{"{player}", string};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.ERROR__PLAYER_NOT_IN_GUILD, stringArray);
        }
        GuildMember guildMember2 = guildMember;
        if (guild.isMaster(offlinePlayer2)) {
            throw new InvalidPermissionException();
        }
        if (RoleUtils.isLower(guildMember2, guild.getMember(player.getUniqueId()))) {
            throw new InvalidPermissionException();
        }
        GuildKickEvent guildKickEvent = new GuildKickEvent(player, guild, offlinePlayer2, GuildKickEvent.Cause.PLAYER_KICKED);
        Bukkit.getPluginManager().callEvent((Event)guildKickEvent);
        if (guildKickEvent.isCancelled()) {
            return;
        }
        this.getGuildHandler().removeGuildPerms(this.getPermission(), offlinePlayer2);
        this.getGuildHandler().removeRolePerm(this.getPermission(), offlinePlayer2);
        CooldownHandler cooldownHandler = this.getCooldownHandler();
        String string2 = Cooldown.Type.Join.name();
        Integer n = this.getSettingsManager().getProperty(CooldownSettings.JOIN);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"settingsManager.getProperty(CooldownSettings.JOIN)");
        cooldownHandler.addCooldown(offlinePlayer2, string2, ((Number)n).intValue(), TimeUnit.SECONDS);
        ClaimUtils.kickMember(offlinePlayer2, player, guild, this.getSettingsManager());
        guild.removeMember(guildMember2);
        this.getGuildHandler().removeFromMemberCache(offlinePlayer2.getUniqueId());
        String[] stringArray = new String[]{"{player}", offlinePlayer2.getName()};
        this.getCurrentCommandIssuer().sendInfo(Messages.BOOT__SUCCESSFUL, stringArray);
        stringArray = new String[]{"{player}", offlinePlayer2.getName(), "{kicker}", player.getName()};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.BOOT__PLAYER_KICKED, stringArray);
        if (!offlinePlayer2.isOnline()) {
            return;
        }
        this.getGuildHandler().removeFromChat(offlinePlayer2.getUniqueId());
        stringArray = new String[]{"{kicker}", player.getName()};
        this.getCurrentCommandManager().getCommandIssuer(offlinePlayer2).sendInfo(Messages.BOOT__KICKED, stringArray);
    }
}

