/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.management;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildPrefixEvent;
import me.glaremasters.guilds.configuration.sections.GuildSettings;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001bH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lme/glaremasters/guilds/commands/management/CommandPrefix;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "prefix", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "", "Guilds"})
public final class CommandPrefix
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @Subcommand(value="prefix")
    @Description(value="{@@descriptions.prefix}")
    @CommandPermission(value="guilds.command.prefix")
    @Syntax(value="%prefix")
    public final void prefix(@NotNull Player player, @Conditions(value="perm:perm=CHANGE_PREFIX") @NotNull Guild guild, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"prefix");
        Boolean bl = this.getSettingsManager().getProperty(GuildSettings.DISABLE_PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"settingsManager.getPrope\u2026dSettings.DISABLE_PREFIX)");
        if (bl.booleanValue()) {
            throw new ExpectationNotMet(Messages.PREFIX__DISABLED);
        }
        if (!this.getGuildHandler().prefixCheck(string, this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.CREATE__PREFIX_TOO_LONG);
        }
        Boolean bl2 = this.getSettingsManager().getProperty(GuildSettings.BLACKLIST_TOGGLE);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"settingsManager.getPrope\u2026ettings.BLACKLIST_TOGGLE)");
        if (bl2.booleanValue() && this.getGuildHandler().blacklistCheck(string, this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.ERROR__BLACKLIST);
        }
        GuildPrefixEvent guildPrefixEvent = new GuildPrefixEvent(player, guild, string);
        Bukkit.getPluginManager().callEvent((Event)guildPrefixEvent);
        if (guildPrefixEvent.isCancelled()) {
            return;
        }
        String[] stringArray = new String[]{"{prefix}", string};
        this.getCurrentCommandIssuer().sendInfo(Messages.PREFIX__SUCCESSFUL, stringArray);
        guild.setPrefix(StringUtils.color(string));
    }
}

