/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.motd;

import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0007J\"\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lme/glaremasters/guilds/commands/motd/CommandMotd;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "check", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "remove", "set", "motd", "", "Guilds"})
public final class CommandMotd
extends BaseCommand {
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @Subcommand(value="motd")
    @Description(value="{@@descriptions.motd}")
    @CommandPermission(value="guilds.command.motd")
    @Syntax(value="")
    public final void check(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        String string = guild.getMotd();
        if (string == null) {
            throw new ExpectationNotMet(Messages.MOTD__NOT_SET);
        }
        String string2 = string;
        String[] stringArray = new String[]{"{motd}", string2};
        this.getCurrentCommandIssuer().sendInfo(Messages.MOTD__MOTD, stringArray);
    }

    @Subcommand(value="motd remove")
    @Description(value="{@@descriptions.motd-remove}")
    @CommandPermission(value="guilds.command.motd.modify")
    @Syntax(value="")
    public final void remove(@NotNull Player player, @Conditions(value="perm:perm=MODIFY_MOTD") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        guild.setMotd(null);
        this.getCurrentCommandIssuer().sendInfo(Messages.MOTD__REMOVE, new String[0]);
    }

    @Subcommand(value="motd set")
    @Description(value="{@@descriptions.motd-set}")
    @CommandPermission(value="guilds.command.motd.modify")
    @Syntax(value="%motd")
    public final void set(@NotNull Player player, @Conditions(value="perm:perm=MODIFY_MOTD") @NotNull Guild guild, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"motd");
        guild.setMotd(StringUtils.color(string));
        String[] stringArray = new String[]{"{motd}", guild.getMotd()};
        this.getCurrentCommandIssuer().sendInfo(Messages.MOTD__SUCCESS, stringArray);
    }
}

