/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration.sections;

import me.glaremasters.guilds.libs.configme.Comment;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.configurationdata.CommentsConfiguration;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.PropertyInitializer;

public final class PluginSettings
implements SettingsHolder {
    @Comment(value={"This is used for the Guild's Announcement System, which allow me (The Author) to communicate to you guys without updating.", "The way this works is very simple. If you have \"console\" set to \"true\", you will see the announcement when the server starts.", "If you have \"in-game\" set to \"true\", your OPed players will see it the first time they login to the server."})
    public static final Property<Boolean> ANNOUNCEMENTS_CONSOLE = PropertyInitializer.newProperty("settings.announcements.console", true);
    public static final Property<Boolean> ANNOUNCEMENTS_IN_GAME = PropertyInitializer.newProperty("settings.announcements.in-game", true);
    @Comment(value={"Choosing your language for the plugin couldn't be easier! The default language is english.", "If you speak another language but don't see it here, feel free to submit it via one of the links above to have it added to the plugin.", "If you try and use a different language than any in the list above, the plugin will not function in a normal manner.", "As you can see this is currently en-US, and there is a en-US.yml file in the language folder.", "If I wanted to switch to french, I would use fr-FR as the language instead."})
    public static final Property<String> MESSAGES_LANGUAGE = PropertyInitializer.newProperty("settings.messagesLanguage", "en-US");
    @Comment(value={"Would you like to check for plugin updates on startup? It's highly suggested you keep this enabled!"})
    public static final Property<Boolean> UPDATE_CHECK = PropertyInitializer.newProperty("settings.update-check", true);
    @Comment(value={"What would you like the command aliases for the plugin to be?", "You can have as many as your want, just separate each with | and NO SPACES."})
    public static final Property<String> PLUGIN_ALIASES = PropertyInitializer.newProperty("settings.plugin-aliases", "guild|guilds|g");
    @Comment(value={"Would you like to run vault permission changes async? (Will be less stress on the main thread and prevent lag)", "Async is used by LuckPerms.", "Set this to false if you are using PEx.", "I do suggest you switch to LuckPerms so that you can keep it async, but ultimately the choice is yours."})
    public static final Property<Boolean> RUN_VAULT_ASYNC = PropertyInitializer.newProperty("settings.run-vault-async", true);

    private PluginSettings() {
    }

    @Override
    public void registerComments(CommentsConfiguration commentsConfiguration) {
        String[] stringArray = new String[]{"Guilds", "Creator: Glare", "Contributors: https://github.com/guilds-plugin/Guilds/graphs/contributors", "Issues: https://github.com/guilds-plugin/Guilds/issues", "Spigot: https://www.spigotmc.org/resources/66176/", "Wiki: https://wiki.glaremasters.me/", "Discord: https://glaremasters.me/discord"};
        commentsConfiguration.setComment("settings", stringArray);
    }
}

