/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration.sections;

import me.glaremasters.guilds.libs.configme.Comment;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.configurationdata.CommentsConfiguration;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.PropertyInitializer;

public class StorageSettings
implements SettingsHolder {
    @Comment(value={"What storage method should be used? (MySQL, MariaDB, JSON, SQLite)"})
    public static final Property<String> STORAGE_TYPE = PropertyInitializer.newProperty("storage.storage-type", "json");
    @Comment(value={"How often (in minutes) do you want all Guild Data to save?"})
    public static final Property<Integer> SAVE_INTERVAL = PropertyInitializer.newProperty("storage.save-interval", 1);
    @Comment(value={"Define the address for the database. (Doesn't apply to SQLite)"})
    public static final Property<String> SQL_HOST = PropertyInitializer.newProperty("storage.sql.host", "localhost");
    @Comment(value={"Define the port for the database. (Doesn't apply to SQLite)"})
    public static final Property<String> SQL_PORT = PropertyInitializer.newProperty("storage.sql.port", "3306");
    @Comment(value={"The name of the database to store data in.", "This must be already created! (Doesn't apply to SQLite)"})
    public static final Property<String> SQL_DATABASE = PropertyInitializer.newProperty("storage.sql.database", "guilds");
    @Comment(value={"The prefix for all Guilds tables."})
    public static final Property<String> SQL_TABLE_PREFIX = PropertyInitializer.newProperty("storage.sql.table-prefix", "guilds_");
    @Comment(value={"Define the credentials for the database. (Doesn't apply to SQLite)"})
    public static final Property<String> SQL_USERNAME = PropertyInitializer.newProperty("storage.sql.username", "root");
    public static final Property<String> SQL_PASSWORD = PropertyInitializer.newProperty("storage.sql.password", "");
    public static final Property<Boolean> UTF8 = PropertyInitializer.newProperty("storage.sql.utf8", true);
    @Comment(value={"Sets whether or not to use SSL for the remote SQL database connection (Doesn't apply to SQLite)"})
    public static final Property<Boolean> SQL_ENABLE_SSL = PropertyInitializer.newProperty("storage.sql.enable-ssl", false);
    @Comment(value={"Sets the maximum size of the SQL connection pool.", "This value will determine the maximum number of connections maintained. (Doesn't apply to SQLite)"})
    public static final Property<Integer> SQL_POOL_SIZE = PropertyInitializer.newProperty("storage.sql.pool.maximum-pool-size", 10);
    @Comment(value={"Sets the minimum number of idle connections that the pool will maintain.", "For maximum performance keep this value the same as 'maximum-pool-size' (Doesn't apply to SQLite)"})
    public static final Property<Integer> SQL_POOL_IDLE = PropertyInitializer.newProperty("storage.sql.pool.minimum-idle", 10);
    @Comment(value={"Sets the maximum lifetime of a connection in the pool in milliseconds. (Doesn't apply to SQLite)"})
    public static final Property<Integer> SQL_POOL_LIFETIME = PropertyInitializer.newProperty("storage.sql.pool.maximum-lifetime", 1800000);
    @Comment(value={"Sets the maximum number of milliseconds for a connection in the pool before timing out. (Doesn't apply to SQLite)"})
    public static final Property<Integer> SQL_POOL_TIMEOUT = PropertyInitializer.newProperty("storage.sql.pool.connection-timeout", 5000);

    private StorageSettings() {
    }

    @Override
    public void registerComments(CommentsConfiguration commentsConfiguration) {
        String[] stringArray = new String[]{"These settings change the SQL connection pool.", "The default settings are optimized for the majority of users.", "Do NOT change these settings unless you know what you are doing!", "For those looking to migrate data:", "IF YOU ARE MIGRATING FROM JSON OR SQLITE TO MYSQL THE SETTINGS MUST BE CONFIGURED EVEN IF THE DATA TYPE IS SET TO JSON OR MYSQL.", "When migrating to MySQL, it will attempt to use the MySQL backend (grab the login information here) in order to connect to the database.", "We are not responsible for data loss if you are too lazy to read the warnings.", "ALWAYS REMEMBER TO BACKUP DATA BEFORE MIGRATING.", "Lastly, remember to change your storage-type to the type you're migrating to before you reboot."};
        commentsConfiguration.setComment("storage.sql.pool", stringArray);
    }
}

