/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database;

import java.util.Arrays;
import me.glaremasters.guilds.database.arenas.ArenaProvider;
import me.glaremasters.guilds.database.arenas.provider.ArenaJsonProvider;
import me.glaremasters.guilds.database.arenas.provider.ArenaMariaDBProvider;
import me.glaremasters.guilds.database.arenas.provider.ArenaMySQLProvider;
import me.glaremasters.guilds.database.arenas.provider.ArenaSQLiteProvider;
import me.glaremasters.guilds.database.challenges.ChallengeProvider;
import me.glaremasters.guilds.database.challenges.provider.ChallengeJsonProvider;
import me.glaremasters.guilds.database.challenges.provider.ChallengeMariaDBProvider;
import me.glaremasters.guilds.database.challenges.provider.ChallengeMySQLProvider;
import me.glaremasters.guilds.database.challenges.provider.ChallengeSQLiteProvider;
import me.glaremasters.guilds.database.cooldowns.CooldownProvider;
import me.glaremasters.guilds.database.cooldowns.provider.CooldownJsonProvider;
import me.glaremasters.guilds.database.cooldowns.provider.CooldownMariaDBProvider;
import me.glaremasters.guilds.database.cooldowns.provider.CooldownMySQLProvider;
import me.glaremasters.guilds.database.cooldowns.provider.CooldownSQLiteProvider;
import me.glaremasters.guilds.database.guild.GuildProvider;
import me.glaremasters.guilds.database.guild.provider.GuildJsonProvider;
import me.glaremasters.guilds.database.guild.provider.GuildMariaDBProvider;
import me.glaremasters.guilds.database.guild.provider.GuildMySQLProvider;
import me.glaremasters.guilds.database.guild.provider.GuildSQLiteProvider;

public enum DatabaseBackend {
    JSON("json", GuildJsonProvider.class, ChallengeJsonProvider.class, ArenaJsonProvider.class, CooldownJsonProvider.class),
    MYSQL("mysql", GuildMySQLProvider.class, ChallengeMySQLProvider.class, ArenaMySQLProvider.class, CooldownMySQLProvider.class),
    SQLITE("sqlite", GuildSQLiteProvider.class, ChallengeSQLiteProvider.class, ArenaSQLiteProvider.class, CooldownSQLiteProvider.class),
    MARIADB("mariadb", GuildMariaDBProvider.class, ChallengeMariaDBProvider.class, ArenaMariaDBProvider.class, CooldownMariaDBProvider.class);

    private final String backendName;
    private final Class<? extends GuildProvider> guildProvider;
    private final Class<? extends ChallengeProvider> challengeProvider;
    private final Class<? extends ArenaProvider> arenaProvider;
    private final Class<? extends CooldownProvider> cooldownProvider;

    private DatabaseBackend(String string2, Class<? extends GuildProvider> clazz, Class<? extends ChallengeProvider> clazz2, Class<? extends ArenaProvider> clazz3, Class<? extends CooldownProvider> clazz4) {
        this.backendName = string2;
        this.guildProvider = clazz;
        this.challengeProvider = clazz2;
        this.arenaProvider = clazz3;
        this.cooldownProvider = clazz4;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public Class<? extends GuildProvider> getGuildProvider() {
        return this.guildProvider;
    }

    public Class<? extends ChallengeProvider> getChallengeProvider() {
        return this.challengeProvider;
    }

    public Class<? extends ArenaProvider> getArenaProvider() {
        return this.arenaProvider;
    }

    public Class<? extends CooldownProvider> getCooldownProvider() {
        return this.cooldownProvider;
    }

    public static DatabaseBackend getByBackendName(String string) {
        return Arrays.stream(DatabaseBackend.values()).filter(databaseBackend -> databaseBackend.backendName.equals(string.toLowerCase())).findFirst().orElse(null);
    }
}

