/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.arenas.provider;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.database.arenas.ArenaProvider;
import me.glaremasters.guilds.utils.LoggingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArenaJsonProvider
implements ArenaProvider {
    private final File dataFolder;
    private Gson gson;

    public ArenaJsonProvider(File file) {
        this.dataFolder = file;
        this.gson = Guilds.getGson();
    }

    @Override
    public void createContainer(@Nullable String string) {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdir();
        }
    }

    @Override
    public boolean arenaExists(@Nullable String string, @NotNull String string3) {
        return Arrays.stream(Objects.requireNonNull(this.dataFolder.listFiles())).map(file -> com.google.common.io.Files.getNameWithoutExtension((String)file.getName())).anyMatch(string2 -> string2.equals(string3));
    }

    @Override
    public List<String> getAllArenaIds(@Nullable String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : Objects.requireNonNull(this.dataFolder.listFiles())) {
            arrayList.add(com.google.common.io.Files.getNameWithoutExtension((String)file.getName()));
        }
        return arrayList;
    }

    @Override
    public List<Arena> getAllArenas(@Nullable String string) {
        ArrayList<Arena> arrayList = new ArrayList<Arena>();
        for (File file : Objects.requireNonNull(this.dataFolder.listFiles())) {
            try {
                Arena arena = this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), Arena.class);
                arena.getId();
                arrayList.add(arena);
            }
            catch (Exception exception) {
                LoggingUtils.severe("There was an error loading an Arena from the following file: " + file.getAbsolutePath());
                LoggingUtils.severe("To prevent data loss in the plugin, this Arena has been prevented from loading.");
            }
        }
        return arrayList;
    }

    @Override
    public Arena getArena(@Nullable String string, @NotNull String string2) {
        File file2 = Arrays.stream(Objects.requireNonNull(this.dataFolder.listFiles())).filter(file -> com.google.common.io.Files.getNameWithoutExtension((String)file.getName()).equals(string2)).findFirst().orElse(null);
        if (file2 == null) {
            return null;
        }
        return this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8), Arena.class);
    }

    @Override
    public void createArena(@Nullable String string, String string2, String string3) {
        if (this.arenaExists(string, string2)) {
            return;
        }
        this.writeArenaFile(new File(this.dataFolder, string2 + ".json"), string3);
    }

    @Override
    public void updateArena(@Nullable String string, @NotNull String string2, @NotNull String string3) {
        File file = new File(this.dataFolder, string2 + ".json");
        this.deleteArena(file);
        this.writeArenaFile(file, string3);
    }

    private void writeArenaFile(File file, String string) {
        Files.write(Paths.get(file.getPath(), new String[0]), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public void deleteArena(@Nullable String string, @NotNull String string2) {
        this.deleteArena(new File(this.dataFolder, string2 + ".json"));
    }

    private void deleteArena(File file) {
        if (file.exists()) {
            file.delete();
        }
    }
}

